/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.vectorized;

import io.fury.format.row.Getters;
import io.fury.format.vectorized.ArrowArrayWriter;
import java.nio.ByteBuffer;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;

class BinaryWriter
extends ArrowArrayWriter {
    private final VarBinaryVector valueVector;

    BinaryWriter(VarBinaryVector valueVector) {
        this.valueVector = valueVector;
    }

    @Override
    void appendValue(Getters getters, int fieldIndex) {
        ByteBuffer buffer = getters.getBuffer(fieldIndex).sliceAsByteBuffer();
        this.valueVector.setSafe(this.rowCount, buffer, buffer.position(), buffer.remaining());
    }

    @Override
    void appendNull() {
        this.valueVector.setNull(this.rowCount);
    }

    @Override
    ValueVector valueVector() {
        return this.valueVector;
    }
}

