/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.vectorized;

import io.fury.format.row.ArrayData;
import io.fury.format.row.Getters;
import io.fury.format.vectorized.ArrowArrayWriter;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;

class ListWriter
extends ArrowArrayWriter {
    private final ListVector valueVector;
    private final ArrowArrayWriter childWriter;

    ListWriter(ListVector valueVector, ArrowArrayWriter childWriter) {
        this.valueVector = valueVector;
        this.childWriter = childWriter;
    }

    @Override
    void appendValue(Getters getters, int fieldIndex) {
        ArrayData array = getters.getArray(fieldIndex);
        this.valueVector.startNewValue(this.rowCount);
        for (int i = 0; i < array.numElements(); ++i) {
            this.childWriter.write(array, i);
        }
        this.valueVector.endValue(this.rowCount, array.numElements());
    }

    @Override
    void appendNull() {
    }

    @Override
    void finish() {
        this.childWriter.finish();
        super.finish();
    }

    @Override
    void reset() {
        this.childWriter.reset();
        super.reset();
    }

    @Override
    ValueVector valueVector() {
        return this.valueVector;
    }
}

