/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.vectorized;

import io.fury.format.row.ArrayData;
import io.fury.format.row.Getters;
import io.fury.format.row.MapData;
import io.fury.format.vectorized.ArrowArrayWriter;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;

class MapWriter
extends ArrowArrayWriter {
    private final MapVector valueVector;
    private final UnionMapWriter mapWriter;
    private final ArrowArrayWriter keyWriter;
    private final ArrowArrayWriter itemWriter;

    MapWriter(MapVector valueVector, ArrowArrayWriter keyWriter, ArrowArrayWriter itemWriter) {
        this.valueVector = valueVector;
        this.mapWriter = valueVector.getWriter();
        this.keyWriter = keyWriter;
        this.itemWriter = itemWriter;
    }

    @Override
    void appendValue(Getters getters, int index) {
        MapData map = getters.getMap(index);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        this.mapWriter.setPosition(this.rowCount);
        this.mapWriter.startMap();
        for (int i = 0; i < map.numElements(); ++i) {
            this.mapWriter.startEntry();
            this.keyWriter.write(keyArray, i);
            this.itemWriter.write(valueArray, i);
            this.mapWriter.endEntry();
        }
        this.mapWriter.endMap();
    }

    @Override
    void appendNull() {
    }

    @Override
    void finish() {
        this.keyWriter.finish();
        this.itemWriter.finish();
        super.finish();
    }

    @Override
    void reset() {
        this.keyWriter.reset();
        this.itemWriter.reset();
        super.reset();
    }

    @Override
    ValueVector valueVector() {
        return this.valueVector;
    }
}

