/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.vectorized;

import io.fury.format.row.Getters;
import io.fury.format.row.Row;
import io.fury.format.vectorized.ArrowArrayWriter;
import java.util.Arrays;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;

class StructWriter
extends ArrowArrayWriter {
    private final StructVector valueVector;
    private final ArrowArrayWriter[] childWriters;

    StructWriter(StructVector valueVector, ArrowArrayWriter[] childWriters) {
        this.valueVector = valueVector;
        this.childWriters = childWriters;
    }

    @Override
    void appendValue(Getters getters, int fieldIndex) {
        Row row = getters.getStruct(fieldIndex);
        for (int i = 0; i < this.childWriters.length; ++i) {
            this.childWriters[i].write(row, i);
        }
        this.valueVector.setIndexDefined(this.rowCount);
    }

    @Override
    void appendNull() {
        for (ArrowArrayWriter childWriter : this.childWriters) {
            childWriter.appendNull();
            ++childWriter.rowCount;
        }
        this.valueVector.setNull(this.rowCount);
    }

    @Override
    void finish() {
        Arrays.stream(this.childWriters).forEach(ArrowArrayWriter::finish);
        super.finish();
    }

    @Override
    void reset() {
        Arrays.stream(this.childWriters).forEach(ArrowArrayWriter::reset);
        super.reset();
    }

    @Override
    ValueVector valueVector() {
        return this.valueVector;
    }
}

