/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xbean.finder.UrlSet;
import org.fusesource.hawtjni.generator.JNIGenerator;
import org.fusesource.hawtjni.generator.NativesGenerator;
import org.fusesource.hawtjni.generator.ProgressMonitor;
import org.fusesource.hawtjni.generator.StatsGenerator;
import org.fusesource.hawtjni.generator.StructsGenerator;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.ReflectClass;
import org.fusesource.hawtjni.generator.util.FileSupport;
import org.fusesource.hawtjni.generator.util.OptionBuilder;
import org.fusesource.hawtjni.runtime.ClassFlag;
import org.fusesource.hawtjni.runtime.JniClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HawtJNI {
    public static final String END_YEAR_TAG = "%END_YEAR%";
    private ProgressMonitor progress;
    private File nativeOutput = new File(".");
    private List<String> classpaths = new ArrayList<String>();
    private List<String> packages = new ArrayList<String>();
    private String name = "hawtjni_native";
    private String copyright = "";
    private boolean callbacks = true;

    public static void main(String[] args) {
        String jv = System.getProperty("java.version").substring(0, 3);
        if (jv.compareTo("1.5") < 0) {
            System.err.println("This application requires jdk 1.5 or higher to run, the current java version is " + System.getProperty("java.version"));
            System.exit(-1);
            return;
        }
        HawtJNI app = new HawtJNI();
        System.exit(app.execute(args));
    }

    public int execute(String[] args) {
        CommandLine cli = null;
        try {
            cli = new PosixParser().parse(HawtJNI.createOptions(), args, true);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            this.displayHelp();
            return 1;
        }
        if (cli.hasOption("h")) {
            this.displayHelp();
            return 0;
        }
        if (cli.hasOption("v")) {
            this.progress = new ProgressMonitor(){

                public void step() {
                }

                public void setTotal(int total) {
                }

                public void setMessage(String message) {
                    System.out.println(message);
                }
            };
        }
        this.name = cli.getOptionValue("n", "hawtjni_native");
        this.nativeOutput = new File(cli.getOptionValue("o", "."));
        String[] values = cli.getOptionValues("p");
        if (values != null) {
            this.packages = Arrays.asList(values);
        }
        if ((values = cli.getArgs()) != null) {
            this.classpaths = Arrays.asList(values);
        }
        try {
            if (this.classpaths.isEmpty()) {
                throw new UsageException("No classpath supplied.");
            }
            this.generate();
        }
        catch (UsageException e) {
            System.err.println("Invalid usage: " + e.getMessage());
            this.displayHelp();
            return 1;
        }
        catch (Throwable e) {
            System.out.flush();
            System.err.println("Unexpected failure:");
            e.printStackTrace();
            HashSet<Throwable> exceptions = new HashSet<Throwable>();
            exceptions.add(e);
            for (int i = 0; i < 10 && (e = e.getCause()) != null && exceptions.add(e); ++i) {
                System.err.println("Reason: " + e);
                e.printStackTrace();
            }
            return 2;
        }
        return 0;
    }

    public ProgressMonitor getProgress() {
        return this.progress;
    }

    public void setProgress(ProgressMonitor progress) {
        this.progress = progress;
    }

    public File getNativeOutput() {
        return this.nativeOutput;
    }

    public void setNativeOutput(File nativeOutput) {
        this.nativeOutput = nativeOutput;
    }

    public List<String> getClasspaths() {
        return this.classpaths;
    }

    public void setClasspaths(List<String> classpaths) {
        this.classpaths = classpaths;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public boolean isCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(boolean enableCallbacks) {
        this.callbacks = enableCallbacks;
    }

    public void generate() throws UsageException, IOException {
        this.progress("Analyzing classes...");
        ArrayList<JNIClass> natives = new ArrayList<JNIClass>();
        ArrayList<JNIClass> structs = new ArrayList<JNIClass>();
        this.findClasses(natives, structs);
        if (natives.isEmpty() && structs.isEmpty()) {
            throw new RuntimeException("No @JniClass or @JniStruct annotated classes found.");
        }
        if (this.progress != null) {
            int nativeCount = 0;
            for (JNIClass clazz : natives) {
                nativeCount += clazz.getNativeMethods().size();
            }
            int total = nativeCount * 4;
            total += natives.size() * 3;
            this.progress.setTotal(total += structs.size() * 2);
        }
        this.nativeOutput.mkdirs();
        this.progress("Generating...");
        File file = this.nativeFile(".c");
        this.generate(new NativesGenerator(), natives, file);
        file = this.nativeFile("_stats.h");
        this.generate(new StatsGenerator(true), natives, file);
        file = this.nativeFile("_stats.c");
        this.generate(new StatsGenerator(false), natives, file);
        file = this.nativeFile("_structs.h");
        this.generate(new StructsGenerator(true), structs, file);
        file = this.nativeFile("_structs.c");
        this.generate(new StructsGenerator(false), structs, file);
        file = new File(this.nativeOutput, "hawtjni.h");
        this.generateFromResource("hawtjni.h", file);
        file = new File(this.nativeOutput, "hawtjni.c");
        this.generateFromResource("hawtjni.c", file);
        file = new File(this.nativeOutput, "hawtjni-callback.c");
        if (this.callbacks) {
            this.generateFromResource("hawtjni-callback.c", file);
        } else {
            file.delete();
        }
        file = new File(this.nativeOutput, "windows");
        file.mkdirs();
        file = new File(file, "stdint.h");
        this.generateFromResource("windows/stdint.h", file);
        this.progress("Done.");
    }

    private void findClasses(ArrayList<JNIClass> jni, ArrayList<JNIClass> structs) throws UsageException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String classpath : this.classpaths) {
            String[] stringArray;
            for (String fileName : stringArray = classpath.replace(';', ':').split(":")) {
                try {
                    File file = new File(fileName);
                    if (file.isDirectory()) {
                        urls.add(new URL(this.url(file) + "/"));
                        continue;
                    }
                    urls.add(new URL(this.url(file)));
                }
                catch (Exception e) {
                    throw new UsageException("Invalid class path.  Not a valid file: " + fileName);
                }
            }
        }
        LinkedHashSet jniClasses = new LinkedHashSet();
        try {
            URLClassLoader classLoader = new URLClassLoader(this.array(URL.class, urls), JniClass.class.getClassLoader());
            UrlSet urlSet2 = new UrlSet(classLoader);
            urlSet2 = urlSet2.excludeJavaHome();
            ClassFinder finder = new ClassFinder((ClassLoader)classLoader, urlSet2.getUrls());
            this.collectMatchingClasses(finder, JniClass.class, jniClasses);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Class clazz : jniClasses) {
            ReflectClass rc = new ReflectClass(clazz);
            if (rc.getFlag(ClassFlag.STRUCT)) {
                structs.add(rc);
            }
            if (rc.getNativeMethods().isEmpty()) continue;
            jni.add(rc);
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Display help information");
        options.addOption("v", "verbose", false, "Verbose generation");
        options.addOption("o", "offline", false, "Work offline");
        options.addOption(OptionBuilder.ob().id("n").name("name").arg("value").description("The base name of the library, used to determine generated file names.  Defaults to 'hawtjni_native'.").op());
        options.addOption(OptionBuilder.ob().id("o").name("native-output").arg("dir").description("Directory where generated native source code will be stored.  Defaults to the current directory.").op());
        options.addOption(OptionBuilder.ob().id("p").name("package").arg("package").description("Restrict looking for JNI classes to the specified package.").op());
        return options;
    }

    private void displayHelp() {
        System.err.flush();
        String app = System.getProperty("hawtjni.application");
        if (app == null) {
            try {
                URL location = this.getClass().getProtectionDomain().getCodeSource().getLocation();
                String[] split = location.toString().split("/");
                if (split[split.length - 1].endsWith(".jar")) {
                    app = split[split.length - 1];
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (app == null) {
                app = this.getClass().getSimpleName();
            }
        }
        this.p();
        this.p("Usage: " + app + " [options] <classpath>");
        this.p();
        this.p("Description:");
        this.p();
        this.pw("  " + app + " is a code generator that produces the JNI code needed to implement java native methods.", 2);
        this.p();
        this.p("Options:");
        this.p();
        PrintWriter out = new PrintWriter(System.out);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printOptions(out, 78, HawtJNI.createOptions(), 2, 2);
        out.flush();
        this.p();
        this.p("Examples:");
        this.p();
        this.pw("  " + app + " -o build foo.jar bar.jar ", 2);
        this.pw("  " + app + " -o build foo.jar:bar.jar ", 2);
        this.pw("  " + app + " -o build -p org.mypackage foo.jar;bar.jar ", 2);
        this.p();
    }

    private void p() {
        System.out.println();
    }

    private void p(String s) {
        System.out.println(s);
    }

    private void pw(String message, int indent) {
        PrintWriter out = new PrintWriter(System.out);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printWrapped(out, 78, indent, message);
        out.flush();
    }

    private void collectMatchingClasses(ClassFinder finder, Class annotation, LinkedHashSet<Class<?>> collector) {
        List<Class> annotated = finder.findAnnotatedClasses(annotation);
        for (Class clazz : annotated) {
            if (this.packages.isEmpty()) {
                collector.add(clazz);
                continue;
            }
            if (!this.packages.contains(clazz.getPackage().getName())) continue;
            collector.add(clazz);
        }
    }

    private void progress(String message) {
        if (this.progress != null) {
            this.progress.setMessage(message);
        }
    }

    private void generate(JNIGenerator gen, ArrayList<JNIClass> classes, File target) throws IOException {
        gen.setOutputName(this.name);
        gen.setClasses(classes);
        gen.setCopyright(this.getCopyright());
        gen.setProgressMonitor(this.progress);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        gen.setOutput(new PrintStream(out));
        gen.generate();
        if (out.size() > 0) {
            if (target.getName().endsWith(".c") && gen.isCPP) {
                target = new File(target.getParentFile(), target.getName() + "pp");
            }
            if (FileSupport.write(out.toByteArray(), target)) {
                this.progress("Wrote: " + target);
            }
        }
    }

    private void generateFromResource(String resource, File target) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resource);
        FileSupport.copy(is, out);
        String content = new String(out.toByteArray(), "UTF-8");
        String[] parts = content.split(Pattern.quote("/* == HEADER-SNIP-LOCATION == */"));
        if (parts.length == 2) {
            content = parts[1];
        }
        out.reset();
        PrintStream ps = new PrintStream(out);
        ps.print(JNIGenerator.fixDelimiter(this.getCopyright()));
        ps.print(JNIGenerator.fixDelimiter(content));
        ps.close();
        if (FileSupport.write(out.toByteArray(), target)) {
            this.progress("Wrote: " + target);
        }
    }

    private <T> T[] array(Class<T> type, ArrayList<T> urls) {
        return urls.toArray((Object[])Array.newInstance(type, urls.size()));
    }

    private String url(File file) throws IOException {
        return "file:" + file.getCanonicalPath().replace(" ", "%20");
    }

    private File nativeFile(String suffix) {
        return new File(this.nativeOutput, this.name + suffix);
    }

    public String getCopyright() {
        if (this.copyright == null) {
            return "";
        }
        int index = this.copyright.indexOf(END_YEAR_TAG);
        if (index != -1) {
            String temp = this.copyright.substring(0, index);
            temp = temp + Calendar.getInstance().get(1);
            this.copyright = temp = temp + this.copyright.substring(index + END_YEAR_TAG.length());
        }
        return this.copyright;
    }

    public static class UsageException
    extends Exception {
        public UsageException(String message) {
            super(message);
        }
    }
}

