/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.fusesource.hawtjni.generator.ProgressMonitor;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIField;
import org.fusesource.hawtjni.generator.model.JNIMethod;
import org.fusesource.hawtjni.generator.model.JNIType;
import org.fusesource.hawtjni.runtime.ClassFlag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JNIGenerator {
    static final String delimiter = System.getProperty("line.separator");
    static final String JNI64 = "JNI64";
    ArrayList<JNIClass> classes;
    String copyright = "";
    boolean isCPP;
    PrintStream output = System.out;
    ProgressMonitor progress;
    private String outputName;

    static String fixDelimiter(String str) {
        if (delimiter.equals("\n")) {
            return str;
        }
        return str.replaceAll("\n", delimiter);
    }

    static String getFunctionName(JNIMethod method) {
        return JNIGenerator.getFunctionName(method, method.getParameterTypes());
    }

    static String getFunctionName(JNIMethod method, List<JNIType> paramTypes) {
        if ((method.getModifiers() & 0x100) == 0) {
            return method.getName();
        }
        String function = JNIGenerator.toC(method.getName());
        if (!method.isNativeUnique()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(function);
            buffer.append("__");
            for (JNIType paramType : paramTypes) {
                buffer.append(JNIGenerator.toC(paramType.getTypeSignature(false)));
            }
            return buffer.toString();
        }
        return function;
    }

    static String loadFile(String file) {
        try {
            int read;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            StringBuffer str = new StringBuffer();
            char[] buffer = new char[1024];
            while ((read = br.read(buffer)) != -1) {
                str.append(buffer, 0, read);
            }
            fr.close();
            return str.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("File not found:" + file, e);
        }
    }

    public static void sortMethods(List<JNIMethod> methods) {
        Collections.sort(methods, new Comparator<JNIMethod>(){

            @Override
            public int compare(JNIMethod mth1, JNIMethod mth2) {
                int result = mth1.getName().compareTo(mth2.getName());
                return result != 0 ? result : JNIGenerator.getFunctionName(mth1).compareTo(JNIGenerator.getFunctionName(mth2));
            }
        });
    }

    static void sortFields(List<JNIField> fields) {
        Collections.sort(fields, new Comparator<JNIField>(){

            @Override
            public int compare(JNIField a, JNIField b) {
                return a.getName().compareTo(b.getName());
            }
        });
    }

    static void sortClasses(ArrayList<JNIClass> classes) {
        Collections.sort(classes, new Comparator<JNIClass>(){

            @Override
            public int compare(JNIClass a, JNIClass b) {
                return a.getName().compareTo(b.getName());
            }
        });
    }

    static String toC(String str) {
        int length = str.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        block7: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '_': {
                    buffer.append("_1");
                    continue block7;
                }
                case ';': {
                    buffer.append("_2");
                    continue block7;
                }
                case '[': {
                    buffer.append("_3");
                    continue block7;
                }
                case '.': {
                    buffer.append("_");
                    continue block7;
                }
                case '/': {
                    buffer.append("_");
                    continue block7;
                }
                default: {
                    if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
                        buffer.append(c);
                        continue block7;
                    }
                    buffer.append(String.format("_0%04x", c));
                }
            }
        }
        return buffer.toString();
    }

    public abstract void generate(JNIClass var1);

    public void generateCopyright() {
    }

    public void generateIncludes() {
    }

    public void generate() {
        if (this.classes == null) {
            return;
        }
        this.generateCopyright();
        this.generateIncludes();
        JNIGenerator.sortClasses(this.classes);
        for (JNIClass clazz : this.classes) {
            if (!clazz.getFlag(ClassFlag.CPP)) continue;
            this.isCPP = true;
            break;
        }
        this.generate(this.classes);
        this.output.flush();
    }

    protected void generate(ArrayList<JNIClass> classes) {
        for (JNIClass clazz : classes) {
            if (clazz.getGenerate()) {
                this.generate(clazz);
            }
            if (this.progress == null) continue;
            this.progress.step();
        }
    }

    public boolean getCPP() {
        return this.isCPP;
    }

    public String getDelimiter() {
        return delimiter;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progress;
    }

    public void output(String str) {
        this.output.print(str);
    }

    public void outputln() {
        this.output(this.getDelimiter());
    }

    public void outputln(String str) {
        this.output(str);
        this.output(this.getDelimiter());
    }

    public void setClasses(ArrayList<JNIClass> classes) {
        this.classes = classes;
    }

    public void setOutput(PrintStream output) {
        this.output = output;
    }

    public void setProgressMonitor(ProgressMonitor progress) {
        this.progress = progress;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }
}

