/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.util.List;
import org.fusesource.hawtjni.generator.JNIGenerator;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIField;
import org.fusesource.hawtjni.generator.model.ReflectClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeofGenerator
extends JNIGenerator {
    @Override
    public void generate(JNIClass clazz) {
        String className = clazz.getSimpleName();
        this.output("\tprintf(\"");
        this.output(className);
        this.output("=%d\\n\", sizeof(");
        this.output(className);
        this.outputln("));");
    }

    @Override
    public void generate() {
        this.outputln("int main() {");
        super.generate();
        this.outputln("}");
    }

    public void generate(List<JNIField> fields) {
        SizeofGenerator.sortFields(fields);
        for (JNIField field : fields) {
            if ((field.getModifiers() & 0x10) == 0) continue;
            this.generate(field);
        }
    }

    public void generate(JNIField field) {
        this.output("\tprintf(\"");
        this.output(field.getName());
        this.output("=%d\\n\", sizeof(");
        this.output(field.getName());
        this.outputln("));");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java SizeofGenerator <className1> <className2>");
            return;
        }
        try {
            SizeofGenerator gen = new SizeofGenerator();
            for (int i = 0; i < args.length; ++i) {
                String clazzName = args[i];
                Class<?> clazz = Class.forName(clazzName);
                gen.generate(new ReflectClass(clazz));
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

