/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fusesource.hawtjni.generator.DOMWriter;
import org.fusesource.hawtjni.generator.HawtJNI;
import org.fusesource.hawtjni.generator.ProgressMonitor;
import org.fusesource.hawtjni.generator.util.FileSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MacGenerator {
    String[] xmls;
    Document[] documents;
    String outputDir;
    String mainClassName;
    String delimiter = System.getProperty("line.separator");
    PrintStream out;

    static void list(File path, ArrayList<String> list) {
        if (path == null) {
            return;
        }
        File[] frameworks = path.listFiles();
        if (frameworks == null) {
            return;
        }
        for (int i = 0; i < frameworks.length; ++i) {
            String xml;
            File file = frameworks[i];
            String name = file.getName();
            int index = name.lastIndexOf(".");
            if (index == -1 || !new File(xml = file.getAbsolutePath() + "/Resources/BridgeSupport/" + name.substring(0, index) + "Full.bridgesupport").exists()) continue;
            list.add(xml);
        }
    }

    int getLevel(Node node) {
        int level = 0;
        while (node != null) {
            ++level;
            node = node.getParentNode();
        }
        return level;
    }

    void merge(Document document, Document extraDocument) {
        if (extraDocument == null) {
            return;
        }
        HashMap<String, Node> extras = new HashMap<String, Node>();
        this.buildLookup(extraDocument, extras);
        HashMap<String, Node> lookup = new HashMap<String, Node>();
        this.merge(document, extras, lookup);
        ArrayList<Node> sortedNodes = Collections.list(Collections.enumeration(extras.values()));
        Collections.sort(sortedNodes, new Comparator<Node>(){

            @Override
            public int compare(Node arg0, Node arg1) {
                int compare = MacGenerator.this.getLevel(arg0) - MacGenerator.this.getLevel(arg1);
                if (compare == 0) {
                    return arg0.getNodeName().compareTo(arg1.getNodeName());
                }
                return compare;
            }
        });
        String delimiter = System.getProperty("line.separator");
        for (Node node : sortedNodes) {
            String name = node.getNodeName();
            if (("arg".equals(name) || "retval".equals(name)) && !sortedNodes.contains(node.getParentNode())) continue;
            Node parent = lookup.get(this.getKey(node.getParentNode()));
            Element element = document.createElement(node.getNodeName());
            String text = parent.getChildNodes().getLength() == 0 ? delimiter : "";
            int level = this.getLevel(parent) - 1;
            for (int i = 0; i < level; ++i) {
                text = text + "  ";
            }
            parent.appendChild(document.createTextNode(text));
            parent.appendChild(element);
            parent.appendChild(document.createTextNode(delimiter));
            NamedNodeMap attributes = node.getAttributes();
            int length = attributes.getLength();
            for (int j = 0; j < length; ++j) {
                Node attr = attributes.item(j);
                element.setAttribute(attr.getNodeName(), attr.getNodeValue());
            }
            lookup.put(this.getKey(element), element);
        }
    }

    public void generate(ProgressMonitor progress) throws HawtJNI.UsageException {
        if (progress != null) {
            progress.setTotal(3);
            progress.setMessage("extra attributes...");
        }
        this.generateExtraAttributes();
        if (progress != null) {
            progress.step();
            progress.setMessage(this.mainClassName);
        }
        this.generateMainClass();
        if (progress != null) {
            progress.step();
            progress.setMessage("classes...");
        }
        this.generateClasses();
        if (progress != null) {
            progress.step();
            progress.setMessage("Done.");
        }
    }

    String fixDelimiter(String str) {
        if (this.delimiter.equals("\n")) {
            return str;
        }
        int index = 0;
        int length = str.length();
        StringBuffer buffer = new StringBuffer();
        while (index != -1) {
            int start = index;
            if ((index = str.indexOf(10, start)) == -1) {
                buffer.append(str.substring(start, length));
                continue;
            }
            buffer.append(str.substring(start, index));
            buffer.append(this.delimiter);
            ++index;
        }
        return buffer.toString();
    }

    void generateMethods(String className, ArrayList<Node> methods) {
        for (Node method : methods) {
            NamedNodeMap paramAttributes;
            Node param;
            int k;
            Node returnNode;
            NamedNodeMap mthAttributes = method.getAttributes();
            String sel = mthAttributes.getNamedItem("selector").getNodeValue();
            this.out("public ");
            boolean isStatic = this.isStatic(method);
            if (isStatic) {
                this.out("static ");
            }
            if (this.getType(returnNode = this.getReturnNode(method.getChildNodes())).equals("void")) {
                returnNode = null;
            }
            String returnType = "";
            String returnType64 = "";
            if (returnNode != null) {
                String type = returnType = this.getJavaType(returnNode);
                String type64 = returnType64 = this.getJavaType64(returnNode);
                this.out(type);
                if (!type.equals(type64)) {
                    this.out(" /*");
                    this.out(type64);
                    this.out("*/");
                }
                this.out(" ");
            } else {
                this.out("void ");
            }
            String methodName = sel;
            if (this.isUnique(method, methods)) {
                int index = methodName.indexOf(":");
                if (index != -1) {
                    methodName = methodName.substring(0, index);
                }
            } else {
                methodName = methodName.replaceAll(":", "_");
                if (isStatic) {
                    methodName = "static_" + methodName;
                }
            }
            this.out(methodName);
            this.out("(");
            NodeList params = method.getChildNodes();
            boolean first = true;
            for (k = 0; k < params.getLength(); ++k) {
                param = params.item(k);
                if (!"arg".equals(param.getNodeName())) continue;
                paramAttributes = param.getAttributes();
                if (!first) {
                    this.out(", ");
                }
                String type = this.getJavaType(param);
                String type64 = this.getJavaType64(param);
                this.out(type);
                if (!type.equals(type64)) {
                    this.out(" /*");
                    this.out(type64);
                    this.out("*/");
                }
                first = false;
                this.out(" ");
                String paramName = paramAttributes.getNamedItem("name").getNodeValue();
                if (paramName.length() == 0) {
                    paramName = "arg" + paramAttributes.getNamedItem("index").getNodeValue();
                }
                if (paramName.equals("boolean")) {
                    paramName = "b";
                }
                this.out(paramName);
            }
            this.out(") {");
            this.outln();
            if (returnNode != null && this.isStruct(returnNode)) {
                this.out("\t");
                this.out(returnType);
                this.out(" result = new ");
                this.out(returnType);
                this.out("();");
                this.outln();
                this.out("\tOS.objc_msgSend_stret(result, ");
            } else if (returnNode != null && this.isBoolean(returnNode)) {
                this.out("\treturn ");
                this.out("OS.objc_msgSend_bool(");
            } else if (returnNode != null && this.isFloatingPoint(returnNode)) {
                this.out("\treturn ");
                if (returnType.equals("float")) {
                    this.out("(float)");
                }
                this.out("OS.objc_msgSend_fpret(");
            } else if (returnNode != null && this.isObject(returnNode)) {
                this.out("\tint /*long*/ result = OS.objc_msgSend(");
            } else {
                if (returnNode != null) {
                    this.out("\treturn ");
                    if (returnType.equals("int") && returnType64.equals("int") || !returnType.equals("int")) {
                        this.out("(");
                        this.out(returnType);
                        this.out(")");
                    }
                    if (returnType.equals("int") && returnType64.equals("int")) {
                        this.out("/*64*/");
                    }
                } else {
                    this.out("\t");
                }
                this.out("OS.objc_msgSend(");
            }
            if (isStatic) {
                this.out("OS.class_");
                this.out(className);
            } else {
                this.out("this.id");
            }
            this.out(", OS.");
            this.out(this.getSelConst(sel));
            first = false;
            for (k = 0; k < params.getLength(); ++k) {
                param = params.item(k);
                if (!"arg".equals(param.getNodeName())) continue;
                paramAttributes = param.getAttributes();
                if (!first) {
                    this.out(", ");
                }
                first = false;
                String paramName = paramAttributes.getNamedItem("name").getNodeValue();
                if (paramName.length() == 0) {
                    paramName = "arg" + paramAttributes.getNamedItem("index").getNodeValue();
                }
                if (paramName.equals("boolean")) {
                    paramName = "b";
                }
                if (this.isObject(param)) {
                    this.out(paramName);
                    this.out(" != null ? ");
                    this.out(paramName);
                    this.out(".id : 0");
                    continue;
                }
                this.out(paramName);
            }
            this.out(")");
            this.out(";");
            this.outln();
            if (returnNode != null && this.isObject(returnNode)) {
                if (!isStatic && returnType.equals(className)) {
                    this.out("\treturn result == this.id ? this : (result != 0 ? new ");
                    this.out(returnType);
                    this.out("(result) : null);");
                } else {
                    this.out("\treturn result != 0 ? new ");
                    NamedNodeMap attributes = returnNode.getAttributes();
                    Node hawtjni_alloc = attributes.getNamedItem("hawtjni_alloc");
                    if (hawtjni_alloc != null && hawtjni_alloc.getNodeValue().equals("true")) {
                        this.out(className);
                    } else {
                        this.out(returnType);
                    }
                    this.out("(result) : null;");
                }
                this.outln();
            } else if (returnNode != null && this.isStruct(returnNode)) {
                this.out("\treturn result;");
                this.outln();
            }
            this.out("}");
            this.outln();
            this.outln();
        }
    }

    void generateExtraMethods(String className) {
        this.out("public ");
        this.out(className);
        this.out("() {");
        this.outln();
        this.out("\tsuper();");
        this.outln();
        this.out("}");
        this.outln();
        this.outln();
        this.out("public ");
        this.out(className);
        this.out("(int /*long*/ id) {");
        this.outln();
        this.out("\tsuper(id);");
        this.outln();
        this.out("}");
        this.outln();
        this.outln();
        this.out("public ");
        this.out(className);
        this.out("(id id) {");
        this.outln();
        this.out("\tsuper(id);");
        this.outln();
        this.out("}");
        this.outln();
        this.outln();
        if (className.equals("NSObject")) {
            this.out("public NSObject alloc() {");
            this.outln();
            this.out("\tthis.id = OS.objc_msgSend(objc_getClass(), OS.sel_alloc);");
            this.outln();
            this.out("\treturn this;");
            this.outln();
            this.out("}");
            this.outln();
            this.outln();
        }
        if (className.equals("NSString")) {
            this.out("public String getString() {");
            this.outln();
            this.out("\tchar[] buffer = new char[(int)/*64*/length()];");
            this.outln();
            this.out("\tgetCharacters(buffer);");
            this.outln();
            this.out("\treturn new String(buffer);");
            this.outln();
            this.out("}");
            this.outln();
            this.outln();
            this.out("public NSString initWithString(String str) {");
            this.outln();
            this.out("\tchar[] buffer = new char[str.length()];");
            this.outln();
            this.out("\tstr.getChars(0, buffer.length, buffer, 0);");
            this.outln();
            this.out("\treturn initWithCharacters(buffer, buffer.length);");
            this.outln();
            this.out("}");
            this.outln();
            this.outln();
            this.out("public static NSString stringWith(String str) {");
            this.outln();
            this.out("\tchar[] buffer = new char[str.length()];");
            this.outln();
            this.out("\tstr.getChars(0, buffer.length, buffer, 0);");
            this.outln();
            this.out("\treturn stringWithCharacters(buffer, buffer.length);");
            this.outln();
            this.out("}");
            this.outln();
            this.outln();
        }
    }

    TreeMap<String, NodeEntry> getGeneratedClasses() {
        TreeMap<String, NodeEntry> classes = new TreeMap<String, NodeEntry>();
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                ArrayList<Node> methods;
                Node node = list.item(i);
                if (!"class".equals(node.getNodeName()) || !this.getGen(node)) continue;
                String name = node.getAttributes().getNamedItem("name").getNodeValue();
                NodeEntry clazz = classes.get(name);
                if (clazz == null) {
                    methods = new ArrayList<Node>();
                    classes.put(name, new NodeEntry(node, methods));
                } else {
                    methods = clazz.children;
                }
                NodeList methodList = node.getChildNodes();
                for (int j = 0; j < methodList.getLength(); ++j) {
                    Node method = methodList.item(j);
                    if (!"method".equals(method.getNodeName()) || !this.getGen(method)) continue;
                    methods.add(method);
                }
            }
        }
        return classes;
    }

    void copyClassMethodsDown(final Map<String, NodeEntry> classes) {
        ArrayList<NodeEntry> sortedClasses = Collections.list(Collections.enumeration(classes.values()));
        Collections.sort(sortedClasses, new Comparator<NodeEntry>(){

            int getHierarchyLevel(Node node) {
                String superclass = MacGenerator.this.getSuperclassName(node);
                int level = 0;
                while (!superclass.equals("id")) {
                    ++level;
                    superclass = MacGenerator.this.getSuperclassName(((NodeEntry)classes.get(superclass)).parent);
                }
                return level;
            }

            @Override
            public int compare(NodeEntry arg0, NodeEntry arg1) {
                return this.getHierarchyLevel(arg0.parent) - this.getHierarchyLevel(arg1.parent);
            }
        });
        for (NodeEntry clazz : sortedClasses) {
            Node node = clazz.parent;
            ArrayList methods = clazz.children;
            NodeEntry superclass = classes.get(this.getSuperclassName(node));
            if (superclass == null) continue;
            for (Node method : superclass.children) {
                if (!this.isStatic(method)) continue;
                methods.add(method);
            }
        }
    }

    String getSuperclassName(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node superclass = attributes.getNamedItem("hawtjni_superclass");
        if (superclass != null) {
            return superclass.getNodeValue();
        }
        Node name = attributes.getNamedItem("name");
        if (name.getNodeValue().equals("NSObject")) {
            return "id";
        }
        return "NSObject";
    }

    void generateClasses() {
        TreeMap<String, NodeEntry> classes = this.getGeneratedClasses();
        this.copyClassMethodsDown(classes);
        Set<String> classNames = classes.keySet();
        Iterator<String> iterator = classNames.iterator();
        while (iterator.hasNext()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.out = new PrintStream(out);
            String className = iterator.next();
            NodeEntry clazz = classes.get(className);
            Node node = clazz.parent;
            ArrayList methods = clazz.children;
            this.out("package ");
            String packageName = this.getPackageName(this.mainClassName);
            this.out(packageName);
            this.out(";");
            this.outln();
            this.outln();
            this.out("public class ");
            this.out(className);
            this.out(" extends ");
            this.out(this.getSuperclassName(node));
            this.out(" {");
            this.outln();
            this.outln();
            this.generateExtraMethods(className);
            this.generateMethods(className, methods);
            this.out("}");
            this.outln();
            String fileName = this.outputDir + packageName.replace('.', '/') + "/" + className + ".java";
            try {
                out.flush();
                if (out.size() > 0) {
                    FileSupport.write(out.toByteArray(), new File(fileName));
                }
            }
            catch (Exception e) {
                System.out.println("Problem");
                e.printStackTrace(System.out);
            }
            out = null;
        }
    }

    void generateExtraAttributes() {
        Document[] documents = this.getDocuments();
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = documents[x];
            if (document == null || !this.getGen(document.getDocumentElement())) continue;
            this.saveExtraAttributes(this.xmls[x], document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateMainClass() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.out = new PrintStream(out);
        String header = "";
        String footer = "";
        String fileName = this.outputDir + this.mainClassName.replace('.', '/') + ".java";
        FileInputStream is = null;
        try {
            int read;
            is = new FileInputStream(fileName);
            InputStreamReader input = new InputStreamReader(new BufferedInputStream(is));
            StringBuffer str = new StringBuffer();
            char[] buffer = new char[4096];
            while ((read = input.read(buffer)) != -1) {
                str.append(buffer, 0, read);
            }
            String section = "/** This section is auto generated */";
            int start = str.indexOf(section) + section.length();
            int end = str.indexOf(section, start);
            header = str.substring(0, start);
            footer = str.substring(end);
        }
        catch (IOException input) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException input) {}
        }
        this.out(header);
        this.outln();
        this.outln();
        this.out("/** Custom callbacks */");
        this.outln();
        this.generateCustomCallbacks();
        this.outln();
        this.out("/** Classes */");
        this.outln();
        this.generateClassesConst();
        this.outln();
        this.out("/** Protocols */");
        this.outln();
        this.generateProtocolsConst();
        this.outln();
        this.out("/** Selectors */");
        this.outln();
        this.generateSelectorsConst();
        this.outln();
        this.out("/** Constants */");
        this.outln();
        this.generateEnums();
        this.outln();
        this.out("/** Globals */");
        this.outln();
        this.generateConstants();
        this.outln();
        this.out("/** Functions */");
        this.outln();
        this.outln();
        this.generateFunctions();
        this.outln();
        this.out("/** Super Sends */");
        this.outln();
        this.generateSends(true);
        this.outln();
        this.out("/** Sends */");
        this.outln();
        this.generateSends(false);
        this.outln();
        this.generateStructNatives();
        this.outln();
        this.out(footer);
        try {
            out.flush();
            if (out.size() > 0) {
                FileSupport.write(out.toByteArray(), new File(fileName));
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    public Document[] getDocuments() {
        if (this.documents == null) {
            String[] xmls = this.getXmls();
            this.documents = new Document[xmls.length];
            for (int i = 0; i < xmls.length; ++i) {
                String xmlPath = xmls[i];
                this.documents[i] = this.getDocument(xmlPath);
                Document document = this.documents[i];
                if (document == null || this.mainClassName == null || this.outputDir == null) continue;
                String packageName = this.getPackageName(this.mainClassName);
                String extrasPath = this.outputDir + packageName.replace('.', '/') + "/" + this.getFileName(xmlPath) + ".extras";
                this.merge(document, this.getDocument(extrasPath));
            }
        }
        return this.documents;
    }

    public String[] getXmls() {
        if (this.xmls == null || this.xmls.length == 0) {
            ArrayList<String> array = new ArrayList<String>();
            MacGenerator.list(new File("/System/Library/Frameworks"), array);
            MacGenerator.list(new File("/System/Library/Frameworks/CoreServices.framework/Frameworks"), array);
            MacGenerator.list(new File("/System/Library/Frameworks/ApplicationServices.framework/Frameworks"), array);
            Collections.sort(array, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return new File(o1).getName().compareTo(new File(o2).getName());
                }
            });
            this.xmls = array.toArray(new String[array.size()]);
        }
        return this.xmls;
    }

    void saveExtraAttributes(String xmlPath, Document document) {
        try {
            String packageName = this.getPackageName(this.mainClassName);
            String fileName = this.outputDir + packageName.replace('.', '/') + "/" + this.getFileName(xmlPath) + ".extras";
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DOMWriter writer = new DOMWriter(new PrintStream(out));
            String[] names = this.getIDAttributeNames();
            String[] filter = new String[names.length + 2];
            filter[0] = "class_method";
            filter[1] = "hawtjni_.*";
            System.arraycopy(names, 0, filter, 2, names.length);
            writer.setAttributeFilter(filter);
            writer.setNodeFilter("hawtjni_");
            writer.print(document);
            if (out.size() > 0) {
                FileSupport.write(out.toByteArray(), new File(fileName));
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    public void setOutputDir(String dir) {
        if (dir != null && !dir.endsWith("\\") && !dir.endsWith("/")) {
            dir = dir + "/";
        }
        this.outputDir = dir;
    }

    public void setXmls(String[] xmls) {
        this.xmls = xmls;
        this.documents = null;
    }

    public void setMainClass(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    Document getDocument(String xmlPath) {
        try {
            InputStream is = null;
            if (xmlPath.indexOf(File.separatorChar) == -1) {
                is = this.getClass().getResourceAsStream(xmlPath);
            }
            if (is == null) {
                is = new BufferedInputStream(new FileInputStream(xmlPath));
            }
            if (is != null) {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(is));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String[] getExtraAttributeNames(Node node) {
        String name = node.getNodeName();
        if (name.equals("method")) {
            return new String[]{"hawtjni_gen_super_msgSend", "hawtjni_gen_custom_callback"};
        }
        if (name.equals("function")) {
            NamedNodeMap attribs = node.getAttributes();
            if (attribs != null && attribs.getNamedItem("variadic") != null) {
                return new String[]{"hawtjni_variadic_count", "hawtjni_variadic_java_types"};
            }
        } else {
            if (name.equals("class")) {
                return new String[]{"hawtjni_superclass"};
            }
            if (name.equals("retval")) {
                return new String[]{"hawtjni_java_type", "hawtjni_java_type64", "hawtjni_alloc"};
            }
            if (name.equals("arg")) {
                return new String[]{"hawtjni_java_type", "hawtjni_java_type64"};
            }
        }
        return new String[0];
    }

    public String getFileName(String xmlPath) {
        File file = new File(xmlPath);
        return file.getName();
    }

    String getKey(Node node) {
        StringBuffer buffer = new StringBuffer();
        while (node != null) {
            NamedNodeMap attributes;
            if (buffer.length() > 0) {
                buffer.append("_");
            }
            String name = node.getNodeName();
            StringBuffer key = new StringBuffer(name);
            Node nameAttrib = this.getIDAttribute(node);
            if (nameAttrib != null) {
                key.append("-");
                key.append(nameAttrib.getNodeValue());
            }
            if ((attributes = node.getAttributes()) != null) {
                boolean isStatic;
                boolean bl = isStatic = attributes.getNamedItem("class_method") != null;
                if (isStatic) {
                    key.append("-static");
                }
            }
            buffer.append(key.reverse());
            node = node.getParentNode();
        }
        buffer.reverse();
        return buffer.toString();
    }

    public Node getIDAttribute(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        String[] names = this.getIDAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            Node nameAttrib = attributes.getNamedItem(names[i]);
            if (nameAttrib == null) continue;
            return nameAttrib;
        }
        return null;
    }

    public String[] getIDAttributeNames() {
        return new String[]{"name", "selector", "path"};
    }

    void merge(Node node, HashMap<String, Node> extras, HashMap<String, Node> docLookup) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() == 1) {
                Node extra;
                String key = this.getKey(childNode);
                if (docLookup != null && docLookup.get(key) == null) {
                    docLookup.put(key, childNode);
                }
                if ((extra = extras.remove(key)) != null) {
                    NamedNodeMap attributes = extra.getAttributes();
                    int length = attributes.getLength();
                    for (int j = 0; j < length; ++j) {
                        Node attr = attributes.item(j);
                        String name = attr.getNodeName();
                        if (!name.startsWith("hawtjni_")) continue;
                        ((Element)childNode).setAttribute(name, attr.getNodeValue());
                    }
                }
            }
            this.merge(childNode, extras, docLookup);
        }
    }

    void out(String str) {
        PrintStream out = this.out;
        if (out == null) {
            out = System.out;
        }
        out.print(str);
    }

    void outln() {
        PrintStream out = this.out;
        if (out == null) {
            out = System.out;
        }
        out.println();
    }

    void generateConstants() {
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!"constant".equals(node.getNodeName()) || !this.getGen(node)) continue;
                NamedNodeMap attributes = node.getAttributes();
                String constName = attributes.getNamedItem("name").getNodeValue();
                this.out("/** @method flags=const */");
                this.outln();
                this.out("public static final native ");
                String type = this.getType(node);
                String type64 = this.getType64(node);
                this.out(type);
                if (!type.equals(type64)) {
                    this.out(" /*");
                    this.out(type64);
                    this.out("*/");
                }
                this.out(" ");
                this.out(constName);
                this.out("();");
                this.outln();
                if (!attributes.getNamedItem("declared_type").getNodeValue().equals("NSString*")) continue;
                this.out("public static final NSString ");
                this.out(constName);
                this.out(" = new NSString(");
                this.out(constName);
                this.out("());");
                this.outln();
            }
        }
    }

    void generateEnums() {
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                NamedNodeMap attributes;
                Node valueNode;
                Node node = list.item(i);
                if (!"enum".equals(node.getNodeName()) || !this.getGen(node) || (valueNode = (attributes = node.getAttributes()).getNamedItem("value")) == null) continue;
                String value = valueNode.getNodeValue();
                this.out("public static final ");
                boolean isLong = false;
                if (value.indexOf(46) != -1) {
                    this.out("double ");
                } else {
                    try {
                        Integer.parseInt(value);
                        this.out("int ");
                    }
                    catch (NumberFormatException e) {
                        isLong = true;
                        this.out("long ");
                    }
                }
                this.out(attributes.getNamedItem("name").getNodeValue());
                this.out(" = ");
                this.out(value);
                if (isLong && !value.endsWith("L")) {
                    this.out("L");
                }
                this.out(";");
                this.outln();
            }
        }
    }

    boolean getGen(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node gen = attributes.getNamedItem("hawtjni_gen");
        return gen != null && !gen.getNodeValue().equals("false");
    }

    boolean getGenSuper(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node gen = attributes.getNamedItem("hawtjni_gen_super_msgSend");
        return gen != null && !gen.getNodeValue().equals("false");
    }

    boolean getGenCallback(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node gen = attributes.getNamedItem("hawtjni_gen_custom_callback");
        return gen != null && !gen.getNodeValue().equals("false");
    }

    boolean isStatic(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node isStatic = attributes.getNamedItem("class_method");
        return isStatic != null && isStatic.getNodeValue().equals("true");
    }

    boolean isStruct(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String code = attributes.getNamedItem("type").getNodeValue();
        return code.startsWith("{");
    }

    boolean isFloatingPoint(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String code = attributes.getNamedItem("type").getNodeValue();
        return code.equals("f") || code.equals("d");
    }

    boolean isObject(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String code = attributes.getNamedItem("type").getNodeValue();
        return code.equals("@");
    }

    boolean isBoolean(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String code = attributes.getNamedItem("type").getNodeValue();
        return code.equals("B");
    }

    void buildLookup(Node node, HashMap<String, Node> table) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() != 1) continue;
            String key = this.getKey(childNode);
            if (table.get(key) == null) {
                table.put(key, childNode);
            }
            this.buildLookup(childNode, table);
        }
    }

    boolean isUnique(Node method, ArrayList<Node> methods) {
        String methodName = method.getAttributes().getNamedItem("selector").getNodeValue();
        String signature = "";
        NodeList params = method.getChildNodes();
        for (int k = 0; k < params.getLength(); ++k) {
            Node param = params.item(k);
            if (!"arg".equals(param.getNodeName())) continue;
            signature = signature + this.getJavaType(param);
        }
        int index = methodName.indexOf(":");
        if (index != -1) {
            methodName = methodName.substring(0, index);
        }
        for (Node node : methods) {
            NamedNodeMap attributes = node.getAttributes();
            Node otherSel = null;
            if (attributes != null) {
                otherSel = attributes.getNamedItem("selector");
            }
            if (node == method || otherSel == null) continue;
            String otherName = otherSel.getNodeValue();
            index = otherName.indexOf(":");
            if (index != -1) {
                otherName = otherName.substring(0, index);
            }
            if (!methodName.equals(otherName)) continue;
            NodeList otherParams = node.getChildNodes();
            String otherSignature = "";
            for (int k = 0; k < otherParams.getLength(); ++k) {
                Node param = otherParams.item(k);
                if (!"arg".equals(param.getNodeName())) continue;
                otherSignature = otherSignature + this.getJavaType(param);
            }
            if (!signature.equals(otherSignature)) continue;
            return false;
        }
        return true;
    }

    void generateSelectorsConst() {
        TreeSet<String> set = new TreeSet<String>();
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!"class".equals(node.getNodeName()) && !"informal_protocol".equals(node.getNodeName()) || !this.getGen(node)) continue;
                NodeList methods = node.getChildNodes();
                for (int j = 0; j < methods.getLength(); ++j) {
                    Node method = methods.item(j);
                    if (!this.getGen(method)) continue;
                    NamedNodeMap mthAttributes = method.getAttributes();
                    String sel = mthAttributes.getNamedItem("selector").getNodeValue();
                    set.add(sel);
                }
            }
        }
        set.add("alloc");
        for (String sel : set) {
            String selConst = this.getSelConst(sel);
            this.out("public static final int /*long*/ ");
            this.out(selConst);
            this.out(" = ");
            this.out("sel_registerName(\"");
            this.out(sel);
            this.out("\");");
            this.outln();
        }
    }

    void generateStructNatives() {
        TreeSet<String> set = new TreeSet<String>();
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!"struct".equals(node.getNodeName()) || !this.getGen(node)) continue;
                set.add(this.getIDAttribute(node).getNodeValue());
            }
        }
        this.out("/** Sizeof natives */");
        this.outln();
        for (String struct : set) {
            this.out("public static final native int ");
            this.out(struct);
            this.out("_sizeof();");
            this.outln();
        }
        this.outln();
        this.out("/** Memmove natives */");
        this.outln();
        this.outln();
        for (String struct : set) {
            this.out("/**");
            this.outln();
            this.out(" * @param dest cast=(void *),flags=no_in critical");
            this.outln();
            this.out(" * @param src cast=(void *),flags=critical");
            this.outln();
            this.out(" */");
            this.outln();
            this.out("public static final native void memmove(");
            this.out("int /*long*/ dest, ");
            this.out(struct);
            this.out(" src, int /*long*/ size);");
            this.outln();
            this.out("/**");
            this.outln();
            this.out(" * @param dest cast=(void *),flags=no_in critical");
            this.outln();
            this.out(" * @param src cast=(void *),flags=critical");
            this.outln();
            this.out(" */");
            this.outln();
            this.out("public static final native void memmove(");
            this.out(struct);
            this.out(" dest, int /*long*/ src, int /*long*/ size);");
            this.outln();
        }
    }

    String buildSend(Node method, boolean tags, boolean only64, boolean superCall) {
        Node returnNode = this.getReturnNode(method.getChildNodes());
        StringBuffer buffer = new StringBuffer();
        buffer.append("public static final native ");
        if (returnNode != null && this.isStruct(returnNode)) {
            buffer.append("void ");
            buffer.append(superCall ? "objc_msgSendSuper_stret" : "objc_msgSend_stret");
            buffer.append("(");
            buffer.append(this.getJavaType(returnNode));
            buffer.append(" result, ");
        } else if (returnNode != null && this.isFloatingPoint(returnNode)) {
            buffer.append("double ");
            buffer.append(superCall ? "objc_msgSendSuper_fpret" : "objc_msgSend_fpret");
            buffer.append("(");
        } else if (returnNode != null && this.isBoolean(returnNode)) {
            buffer.append("boolean ");
            buffer.append(superCall ? "objc_msgSendSuper_bool" : "objc_msgSend_bool");
            buffer.append("(");
        } else {
            if (only64) {
                buffer.append("long");
            } else if (tags) {
                buffer.append("int /*long*/");
            } else {
                buffer.append("int");
            }
            buffer.append(" ");
            buffer.append(superCall ? "objc_msgSendSuper" : "objc_msgSend");
            buffer.append("(");
        }
        if (superCall) {
            if (only64) {
                buffer.append("objc_super superId, long sel");
            } else if (tags) {
                buffer.append("objc_super superId, int /*long*/ sel");
            } else {
                buffer.append("objc_super superId, int sel");
            }
        } else if (only64) {
            buffer.append("long id, long sel");
        } else if (tags) {
            buffer.append("int /*long*/ id, int /*long*/ sel");
        } else {
            buffer.append("int id, int sel");
        }
        NodeList params = method.getChildNodes();
        boolean first = false;
        int count = 0;
        for (int k = 0; k < params.getLength(); ++k) {
            Node param = params.item(k);
            if (!"arg".equals(param.getNodeName())) continue;
            if (!first) {
                buffer.append(", ");
            }
            if (this.isStruct(param)) {
                buffer.append(this.getJavaType(param));
            } else {
                String type = this.getType(param);
                String type64 = this.getType64(param);
                buffer.append(only64 ? type64 : type);
                if (!only64 && tags && !type.equals(type64)) {
                    buffer.append(" /*");
                    buffer.append(type64);
                    buffer.append("*/");
                }
            }
            first = false;
            buffer.append(" arg");
            buffer.append(String.valueOf(count++));
        }
        buffer.append(");");
        return buffer.toString();
    }

    String getCType(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        return attributes.getNamedItem("declared_type").getNodeValue();
    }

    Node findNSObjectMethod(Node method) {
        NamedNodeMap methodAttributes = method.getAttributes();
        String selector = methodAttributes.getNamedItem("selector").getNodeValue();
        NodeList list = method.getParentNode().getParentNode().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            NamedNodeMap classAttributes;
            Node cls = list.item(i);
            if (!"class".equals(cls.getNodeName()) || !"NSObject".equals((classAttributes = cls.getAttributes()).getNamedItem("name").getNodeValue())) continue;
            NodeList methods = cls.getChildNodes();
            for (int j = 0; j < methods.getLength(); ++j) {
                NamedNodeMap mthAttributes;
                Node mth = methods.item(j);
                if (!"method".equals(mth.getNodeName()) || !selector.equals((mthAttributes = mth.getAttributes()).getNamedItem("selector").getNodeValue())) continue;
                return mth;
            }
        }
        return null;
    }

    void generateCustomCallbacks() {
        TreeMap<String, Node> set = new TreeMap<String, Node>();
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!"class".equals(node.getNodeName()) && !"informal_protocol".equals(node.getNodeName()) || !this.getGen(node)) continue;
                NodeList methods = node.getChildNodes();
                for (int j = 0; j < methods.getLength(); ++j) {
                    Node method = methods.item(j);
                    if (!"method".equals(method.getNodeName()) || !this.getGen(method) || !this.getGenCallback(method)) continue;
                    NamedNodeMap mthAttributes = method.getAttributes();
                    String sel = mthAttributes.getNamedItem("selector").getNodeValue();
                    set.put(sel, method);
                }
            }
        }
        for (String key : set.keySet()) {
            Node param;
            int k;
            Node method = (Node)set.get(key);
            if ("informal_protocol".equals(method.getParentNode().getNodeName()) && (method = this.findNSObjectMethod(method)) == null) continue;
            String nativeMth = key.replaceAll(":", "_");
            this.out("/** @method callback_types=");
            Node returnNode = this.getReturnNode(method.getChildNodes());
            this.out(returnNode == null ? "void" : this.getCType(returnNode));
            this.out(";id;SEL;");
            NodeList params = method.getChildNodes();
            for (k = 0; k < params.getLength(); ++k) {
                param = params.item(k);
                if (!"arg".equals(param.getNodeName())) continue;
                this.out(this.getCType(param));
                this.out(";");
            }
            this.out(",callback_flags=");
            this.out(returnNode != null && this.isStruct(returnNode) ? "struct" : "none");
            this.out(";none;none;");
            for (k = 0; k < params.getLength(); ++k) {
                param = params.item(k);
                if (!"arg".equals(param.getNodeName())) continue;
                this.out(this.isStruct(param) ? "struct" : "none");
                this.out(";");
            }
            this.out(" */");
            this.outln();
            this.out("public static final native int /*long*/ CALLBACK_");
            this.out(nativeMth);
            this.out("(int /*long*/ func);");
            this.outln();
        }
    }

    void generateSends(boolean superCall) {
        Node method;
        TreeMap<String, Node> set = new TreeMap<String, Node>();
        TreeMap<String, Node> set64 = new TreeMap<String, Node>();
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!"class".equals(node.getNodeName()) || !this.getGen(node)) continue;
                NodeList methods = node.getChildNodes();
                for (int j = 0; j < methods.getLength(); ++j) {
                    Node method2 = methods.item(j);
                    if (!"method".equals(method2.getNodeName()) || !this.getGen(method2) || superCall && !this.getGenSuper(method2)) continue;
                    String code = this.buildSend(method2, false, false, superCall);
                    String code64 = this.buildSend(method2, false, true, superCall);
                    if (set.get(code) == null) {
                        set.put(code, method2);
                    }
                    if (set64.get(code64) != null) continue;
                    set64.put(code64, method2);
                }
            }
        }
        this.outln();
        TreeMap<String, Node> tagsSet = new TreeMap<String, Node>();
        Iterator iterator = set.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Node method3 = (Node)set.get(key);
            String tagCode = this.buildSend(method3, false, true, superCall);
            if (set64.get(tagCode) == null) continue;
            tagsSet.put(key, method3);
            iterator.remove();
            set64.remove(tagCode);
        }
        TreeMap<String, Node> all = new TreeMap<String, Node>();
        for (String key : tagsSet.keySet()) {
            method = (Node)tagsSet.get(key);
            all.put(this.buildSend(method, true, false, superCall), method);
        }
        for (String key : set.keySet()) {
            all.put(key, (Node)set.get(key));
        }
        for (String key : set64.keySet()) {
            all.put(key, (Node)set64.get(key));
        }
        for (String key : all.keySet()) {
            method = (Node)all.get(key);
            NodeList params = method.getChildNodes();
            ArrayList<String> tags = new ArrayList<String>();
            int count = 0;
            for (int k = 0; k < params.getLength(); ++k) {
                Node param = params.item(k);
                if (!"arg".equals(param.getNodeName())) continue;
                if (this.isStruct(param)) {
                    tags.add(" * @param arg" + count + " flags=struct");
                }
                ++count;
            }
            this.out("/**");
            if (tags.size() > 0) {
                this.outln();
                this.out(" *");
            }
            this.out(" @method flags=cast");
            if (tags.size() > 0) {
                this.outln();
            }
            for (String tag : tags) {
                this.out(tag);
                this.outln();
            }
            this.out(" */");
            this.outln();
            this.out(key.toString());
            this.outln();
        }
    }

    String getSelConst(String sel) {
        return "sel_" + sel.replaceAll(":", "_");
    }

    void generateClassesConst() {
        TreeSet<String> set = new TreeSet<String>();
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!"class".equals(node.getNodeName()) || !this.getGen(node)) continue;
                NamedNodeMap attributes = node.getAttributes();
                String name = attributes.getNamedItem("name").getNodeValue();
                set.add(name);
            }
        }
        for (String cls : set) {
            String clsConst = "class_" + cls;
            this.out("public static final int /*long*/ ");
            this.out(clsConst);
            this.out(" = ");
            this.out("objc_getClass(\"");
            this.out(cls);
            this.out("\");");
            this.outln();
        }
    }

    void generateProtocolsConst() {
        TreeSet<String> set = new TreeSet<String>();
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!"informal_protocol".equals(node.getNodeName()) || !this.getGen(node)) continue;
                NamedNodeMap attributes = node.getAttributes();
                String name = attributes.getNamedItem("name").getNodeValue();
                set.add(name);
            }
        }
        for (String cls : set) {
            String clsConst = "protocol_" + cls;
            this.out("public static final int /*long*/ ");
            this.out(clsConst);
            this.out(" = ");
            this.out("objc_getProtocol(\"");
            this.out(cls);
            this.out("\");");
            this.outln();
        }
    }

    String getPackageName(String className) {
        int dot = this.mainClassName.lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return this.mainClassName.substring(0, dot);
    }

    String getClassName(String className) {
        int dot = this.mainClassName.lastIndexOf(46);
        if (dot == -1) {
            return this.mainClassName;
        }
        return this.mainClassName.substring(dot + 1);
    }

    Node getReturnNode(NodeList list) {
        for (int j = 0; j < list.getLength(); ++j) {
            Node node = list.item(j);
            if (!"retval".equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }

    String getType(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node javaType = attributes.getNamedItem("hawtjni_java_type");
        if (javaType != null) {
            return javaType.getNodeValue();
        }
        String code = attributes.getNamedItem("type").getNodeValue();
        return this.getType(code, attributes, false);
    }

    String getType64(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node javaType = attributes.getNamedItem("hawtjni_java_type");
        if (javaType != null) {
            Node javaType64 = attributes.getNamedItem("hawtjni_java_type64");
            return javaType64 != null ? javaType64.getNodeValue() : javaType.getNodeValue();
        }
        Node attrib = attributes.getNamedItem("type");
        String code = attrib.getNodeValue();
        Node attrib64 = attributes.getNamedItem("type64");
        if (attrib64 != null) {
            code = attrib64.getNodeValue();
        }
        return this.getType(code, attributes, true);
    }

    String getType(String code, NamedNodeMap attributes, boolean is64) {
        if (code.equals("c")) {
            return "byte";
        }
        if (code.equals("i")) {
            return "int";
        }
        if (code.equals("s")) {
            return "short";
        }
        if (code.equals("l")) {
            return "int";
        }
        if (code.equals("q")) {
            return "long";
        }
        if (code.equals("C")) {
            return "byte";
        }
        if (code.equals("I")) {
            return "int";
        }
        if (code.equals("S")) {
            return "short";
        }
        if (code.equals("L")) {
            return "int";
        }
        if (code.equals("Q")) {
            return "long";
        }
        if (code.equals("f")) {
            return "float";
        }
        if (code.equals("d")) {
            return "double";
        }
        if (code.equals("B")) {
            return "boolean";
        }
        if (code.equals("v")) {
            return "void";
        }
        if (code.equals("*")) {
            return is64 ? "long" : "int";
        }
        if (code.equals("@")) {
            return is64 ? "long" : "int";
        }
        if (code.equals("#")) {
            return is64 ? "long" : "int";
        }
        if (code.equals(":")) {
            return is64 ? "long" : "int";
        }
        if (code.startsWith("^")) {
            return is64 ? "long" : "int";
        }
        if (code.startsWith("{")) {
            return attributes.getNamedItem("declared_type").getNodeValue();
        }
        return "BAD " + code;
    }

    String getJNIType(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String code = attributes.getNamedItem("type").getNodeValue();
        if (code.equals("c")) {
            return "B";
        }
        if (code.equals("i")) {
            return "I";
        }
        if (code.equals("s")) {
            return "S";
        }
        if (code.equals("l")) {
            return "I";
        }
        if (code.equals("q")) {
            return "J";
        }
        if (code.equals("C")) {
            return "B";
        }
        if (code.equals("I")) {
            return "I";
        }
        if (code.equals("S")) {
            return "S";
        }
        if (code.equals("L")) {
            return "I";
        }
        if (code.equals("Q")) {
            return "J";
        }
        if (code.equals("f")) {
            return "F";
        }
        if (code.equals("d")) {
            return "D";
        }
        if (code.equals("B")) {
            return "Z";
        }
        if (code.equals("v")) {
            return "V";
        }
        if (code.equals("*")) {
            return "I";
        }
        if (code.equals("@")) {
            return "I";
        }
        if (code.equals("#")) {
            return "I";
        }
        if (code.equals(":")) {
            return "I";
        }
        if (code.startsWith("^")) {
            return "I";
        }
        if (code.startsWith("[")) {
            return "BAD " + code;
        }
        if (code.startsWith("{")) {
            return "BAD " + code;
        }
        if (code.startsWith("(")) {
            return "BAD " + code;
        }
        return "BAD " + code;
    }

    String getJavaType(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node javaType = attributes.getNamedItem("hawtjni_java_type");
        if (javaType != null) {
            return javaType.getNodeValue().trim();
        }
        String code = attributes.getNamedItem("type").getNodeValue();
        return this.getJavaType(code, attributes, false);
    }

    String getJavaType64(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node javaType = attributes.getNamedItem("hawtjni_java_type");
        if (javaType != null) {
            Node javaType64 = attributes.getNamedItem("hawtjni_java_type64");
            return javaType64 != null ? javaType64.getNodeValue() : javaType.getNodeValue();
        }
        Node attrib = attributes.getNamedItem("type");
        String code = attrib.getNodeValue();
        Node attrib64 = attributes.getNamedItem("type64");
        if (attrib64 != null) {
            code = attrib64.getNodeValue();
        }
        return this.getJavaType(code, attributes, true);
    }

    String getJavaType(String code, NamedNodeMap attributes, boolean is64) {
        if (code.equals("c")) {
            return "byte";
        }
        if (code.equals("i")) {
            return "int";
        }
        if (code.equals("s")) {
            return "short";
        }
        if (code.equals("l")) {
            return "int";
        }
        if (code.equals("q")) {
            return "long";
        }
        if (code.equals("C")) {
            return "byte";
        }
        if (code.equals("I")) {
            return "int";
        }
        if (code.equals("S")) {
            return "short";
        }
        if (code.equals("L")) {
            return "int";
        }
        if (code.equals("Q")) {
            return "long";
        }
        if (code.equals("f")) {
            return "float";
        }
        if (code.equals("d")) {
            return "double";
        }
        if (code.equals("B")) {
            return "boolean";
        }
        if (code.equals("v")) {
            return "void";
        }
        if (code.equals("*")) {
            return is64 ? "long" : "int";
        }
        if (code.equals("#")) {
            return is64 ? "long" : "int";
        }
        if (code.equals(":")) {
            return is64 ? "long" : "int";
        }
        if (code.startsWith("^")) {
            return is64 ? "long" : "int";
        }
        if (code.equals("@")) {
            String type = attributes.getNamedItem("declared_type").getNodeValue();
            int index = type.indexOf(42);
            if (index != -1) {
                type = type.substring(0, index);
            }
            if ((index = type.indexOf(60)) != -1) {
                type = type.substring(0, index);
            }
            return type.trim();
        }
        if (code.startsWith("{")) {
            return attributes.getNamedItem("declared_type").getNodeValue().trim();
        }
        return "BAD " + code;
    }

    static String[] split(String str, String separator) {
        StringTokenizer tk = new StringTokenizer(str, separator);
        ArrayList<Object> result = new ArrayList<Object>();
        while (tk.hasMoreElements()) {
            result.add(tk.nextElement());
        }
        return result.toArray(new String[result.size()]);
    }

    void generateFunctions() {
        for (int x = 0; x < this.xmls.length; ++x) {
            Document document = this.documents[x];
            if (document == null) continue;
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node param;
                int j;
                Node node = list.item(i);
                if (!"function".equals(node.getNodeName()) || !this.getGen(node)) continue;
                NamedNodeMap attributes = node.getAttributes();
                String name = attributes.getNamedItem("name").getNodeValue();
                NodeList params = node.getChildNodes();
                int count = 0;
                for (j = 0; j < params.getLength(); ++j) {
                    param = params.item(j);
                    if (!"arg".equals(param.getNodeName())) continue;
                    ++count;
                }
                if (count > 0) {
                    this.out("/**");
                    this.outln();
                }
                for (j = 0; j < params.getLength(); ++j) {
                    param = params.item(j);
                    if (!"arg".equals(param.getNodeName())) continue;
                    NamedNodeMap paramAttributes = param.getAttributes();
                    this.out(" * @param ");
                    this.out(paramAttributes.getNamedItem("name").getNodeValue());
                    if (this.isStruct(param)) {
                        this.out(" flags=struct");
                    } else {
                        this.out(" cast=");
                        Node declaredType = paramAttributes.getNamedItem("declared_type");
                        String cast = declaredType.getNodeValue();
                        if (!cast.startsWith("(")) {
                            this.out("(");
                        }
                        this.out(cast);
                        if (!cast.endsWith(")")) {
                            this.out(")");
                        }
                    }
                    this.outln();
                }
                if (count > 0) {
                    this.out(" */");
                    this.outln();
                }
                this.out("public static final native ");
                Node returnNode = this.getReturnNode(node.getChildNodes());
                if (returnNode != null) {
                    String type = this.getType(returnNode);
                    String type64 = this.getType64(returnNode);
                    this.out(type);
                    if (!type.equals(type64)) {
                        this.out(" /*");
                        this.out(type64);
                        this.out("*/");
                    }
                    this.out(" ");
                } else {
                    this.out("void ");
                }
                this.out(name);
                this.out("(");
                params = node.getChildNodes();
                boolean first = true;
                for (int j2 = 0; j2 < params.getLength(); ++j2) {
                    Node param2 = params.item(j2);
                    if (!"arg".equals(param2.getNodeName())) continue;
                    NamedNodeMap paramAttributes = param2.getAttributes();
                    if (!first) {
                        this.out(", ");
                    }
                    first = false;
                    String type = this.getType(param2);
                    String type64 = this.getType64(param2);
                    this.out(type);
                    if (!type.equals(type64)) {
                        this.out(" /*");
                        this.out(type64);
                        this.out("*/");
                    }
                    this.out(" ");
                    this.out(paramAttributes.getNamedItem("name").getNodeValue());
                }
                this.generateVariadics(node);
                this.out(");");
                this.outln();
            }
        }
    }

    void generateVariadics(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node variadicCount = attributes.getNamedItem("hawtjni_variadic_count");
        if (variadicCount != null) {
            Node variadicTypes = attributes.getNamedItem("hawtjni_variadic_java_types");
            String[] types = null;
            if (variadicTypes != null) {
                types = MacGenerator.split(variadicTypes.getNodeValue(), ",");
            }
            int varCount = 0;
            try {
                varCount = Integer.parseInt(variadicCount.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (int j = 0; j < varCount; ++j) {
                this.out(", ");
                if (types != null && types.length > j && !types[j].equals("*")) {
                    this.out(types[j]);
                } else if (types != null && types[types.length - 1].equals("*")) {
                    this.out(types[types.length - 2]);
                } else {
                    this.out("int /*long*/");
                }
                this.out(" varArg");
                this.out("" + j);
            }
        }
    }

    public static void main(String[] args) {
        try {
            MacGenerator gen = new MacGenerator();
            gen.setXmls(args);
            gen.setOutputDir("../org.eclipse.hawtjni/Eclipse SWT PI/cocoa/");
            gen.setMainClass("org.eclipse.hawtjni.internal.cocoa.OS");
            gen.generate(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static class NodeEntry {
        private final Node parent;
        private final ArrayList<Node> children;

        public NodeEntry(Node parent, ArrayList<Node> children) {
            this.parent = parent;
            this.children = children;
        }
    }
}

