/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIField;
import org.fusesource.hawtjni.generator.model.JNIMethod;
import org.fusesource.hawtjni.generator.model.ReflectField;
import org.fusesource.hawtjni.generator.model.ReflectMethod;
import org.fusesource.hawtjni.runtime.ClassFlag;
import org.fusesource.hawtjni.runtime.JniClass;

public class ReflectClass
implements JNIClass {
    private Class<?> clazz;
    private ArrayList<ReflectField> fields;
    private ArrayList<ReflectMethod> methods;
    private JniClass annotation;
    private HashSet<ClassFlag> flags;
    private String nativeName;

    public ReflectClass(Class<?> clazz) {
        this.clazz = clazz;
    }

    public String toString() {
        return this.clazz.toString();
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReflectClass)) {
            return false;
        }
        return ((ReflectClass)obj).clazz.equals(this.clazz);
    }

    public Class<?> getWrapedClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public JNIClass getSuperclass() {
        return new ReflectClass(this.clazz.getSuperclass());
    }

    @Override
    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    @Override
    public String getNativeName() {
        this.lazyLoad();
        if (this.nativeName != null) {
            return this.nativeName;
        }
        return this.getSimpleName();
    }

    @Override
    public List<JNIField> getDeclaredFields() {
        this.lazyLoad();
        return new ArrayList<JNIField>(this.fields);
    }

    @Override
    public List<JNIMethod> getDeclaredMethods() {
        this.lazyLoad();
        return new ArrayList<JNIMethod>(this.methods);
    }

    @Override
    public List<JNIMethod> getNativeMethods() {
        ArrayList<JNIMethod> rc = new ArrayList<JNIMethod>();
        for (JNIMethod method : this.getDeclaredMethods()) {
            if ((method.getModifiers() & 0x100) == 0) continue;
            rc.add(method);
        }
        return rc;
    }

    @Override
    public String getConditional() {
        this.lazyLoad();
        return this.annotation == null ? null : ReflectClass.emptyFilter(this.annotation.conditional());
    }

    @Override
    public boolean getGenerate() {
        return !this.getFlag(ClassFlag.CLASS_SKIP);
    }

    @Override
    public boolean getFlag(ClassFlag flag) {
        this.lazyLoad();
        return this.flags.contains((Object)flag);
    }

    public static String emptyFilter(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private void lazyLoad() {
        if (this.fields != null) {
            return;
        }
        this.annotation = this.clazz.getAnnotation(JniClass.class);
        this.flags = new HashSet();
        if (this.annotation != null) {
            this.flags.addAll(Arrays.asList(this.annotation.flags()));
            if (this.annotation.name().trim().length() > 0) {
                this.nativeName = this.annotation.name().trim();
            }
        }
        Field[] fields = this.clazz.getDeclaredFields();
        this.fields = new ArrayList(fields.length);
        for (Field field : fields) {
            this.fields.add(new ReflectField(this, field));
        }
        Method[] methods = this.clazz.getDeclaredMethods();
        this.methods = new ArrayList(methods.length);
        for (Method method : methods) {
            this.methods.add(new ReflectMethod(this, method));
        }
    }
}

