/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.maven;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;
import org.fusesource.hawtjni.generator.HawtJNI;
import org.fusesource.hawtjni.generator.ProgressMonitor;
import org.fusesource.hawtjni.maven.CLI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateMojo
extends AbstractMojo {
    protected MavenProject project;
    private File generatedNativeSourceDirectory;
    private String name;
    private String copyright;
    private List<String> packages = new ArrayList<String>();
    private File classesDirectory;
    private File packageDirectory;
    private File customPackageDirectory;
    private String encoding;
    private boolean skipAutogen;
    private boolean forceAutogen;
    private boolean verbose;
    private List<String> autogenArgs;
    private boolean callbacks;
    private File targetSrcDir;
    private CLI cli = new CLI();

    public void execute() throws MojoExecutionException {
        this.cli.verbose = this.verbose;
        this.cli.log = this.getLog();
        this.generateNativeSourceFiles();
        this.generateBuildSystem();
    }

    private void generateNativeSourceFiles() throws MojoExecutionException {
        HawtJNI generator = new HawtJNI();
        generator.setClasspaths(this.getClasspath());
        generator.setName(this.name);
        generator.setCopyright(this.copyright);
        generator.setNativeOutput(this.generatedNativeSourceDirectory);
        generator.setPackages(this.packages);
        generator.setCallbacks(this.callbacks);
        generator.setProgress(new ProgressMonitor(){

            public void step() {
            }

            public void setTotal(int total) {
            }

            public void setMessage(String message) {
                GenerateMojo.this.getLog().info((CharSequence)message);
            }
        });
        try {
            generator.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Native source code generation failed: " + e, e);
        }
    }

    private void generateBuildSystem() throws MojoExecutionException {
        try {
            this.packageDirectory.mkdirs();
            new File(this.packageDirectory, "m4").mkdirs();
            this.targetSrcDir = new File(this.packageDirectory, "src");
            this.targetSrcDir.mkdirs();
            if (this.customPackageDirectory != null && this.customPackageDirectory.isDirectory()) {
                FileUtils.copyDirectoryStructureIfModified((File)this.customPackageDirectory, (File)this.packageDirectory);
            }
            if (this.generatedNativeSourceDirectory != null && this.generatedNativeSourceDirectory.isDirectory()) {
                FileUtils.copyDirectoryStructureIfModified((File)this.generatedNativeSourceDirectory, (File)this.targetSrcDir);
            }
            this.copyTemplateResource("readme.md", false);
            this.copyTemplateResource("configure.ac", true);
            this.copyTemplateResource("Makefile.am", true);
            this.copyTemplateResource("m4/custom.m4", false);
            this.copyTemplateResource("m4/jni.m4", false);
            this.copyTemplateResource("m4/osx-universal.m4", false);
            this.copyTemplateResource("vs2008.vcproj", true);
            this.copyTemplateResource("vs2010.vcxproj", true);
            File autogen = new File(this.packageDirectory, "autogen.sh");
            File configure = new File(this.packageDirectory, "configure");
            if (!autogen.exists()) {
                this.copyTemplateResource("autogen.sh", false);
                this.cli.setExecutable(autogen);
            }
            if (!this.skipAutogen && (!configure.exists() && !CLI.IS_WINDOWS || this.forceAutogen)) {
                try {
                    this.cli.system(this.packageDirectory, new String[]{"./autogen.sh"}, this.autogenArgs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Native build system generation failed: " + e, e);
        }
    }

    private ArrayList<String> getClasspath() throws MojoExecutionException {
        ArrayList<String> artifacts = new ArrayList<String>();
        try {
            artifacts.add(this.classesDirectory.getCanonicalPath());
            for (Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                this.getLog().debug((CharSequence)("Including: " + file));
                artifacts.add(file.getCanonicalPath());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not determine project classath.", (Exception)e);
        }
        return artifacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTemplateResource(String file, boolean filter) throws MojoExecutionException {
        try {
            File target = FileUtils.resolveFile((File)this.packageDirectory, (String)file);
            if (target.isFile() && target.canRead()) {
                return;
            }
            URL source = ((Object)((Object)this)).getClass().getClassLoader().getResource("project-template/" + file);
            File tmp = FileUtils.createTempFile((String)"tmp", (String)"txt", (File)new File(this.project.getBuild().getDirectory()));
            try {
                FileUtils.copyURLToFile((URL)source, (File)tmp);
                FileUtils.copyFile((File)tmp, (File)target, (String)this.encoding, (FileUtils.FilterWrapper[])this.filters(filter), (boolean)true);
            }
            finally {
                tmp.delete();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not extract template resource: " + file, (Exception)e);
        }
    }

    private FileUtils.FilterWrapper[] filters(boolean filter) throws IOException {
        if (!filter) {
            return new FileUtils.FilterWrapper[0];
        }
        String startExp = "@";
        String endExp = "@";
        String escapeString = "\\";
        final HashMap<String, String> values = new HashMap<String, String>();
        values.put("PROJECT_NAME", this.name);
        values.put("PROJECT_NAME_UNDER_SCORE", this.name.replaceAll("\\W", "_"));
        values.put("VERSION", this.project.getVersion());
        ArrayList files = new ArrayList();
        files.addAll(FileUtils.getFileNames((File)this.targetSrcDir, (String)"**/*.c", null, (boolean)false));
        files.addAll(FileUtils.getFileNames((File)this.targetSrcDir, (String)"**/*.cpp", null, (boolean)false));
        files.addAll(FileUtils.getFileNames((File)this.targetSrcDir, (String)"**/*.cxx", null, (boolean)false));
        String sources = "";
        String xml_sources = "";
        String vs10_sources = "";
        boolean first = true;
        for (String f : files) {
            if (!first) {
                sources = sources + "\\\n";
            } else {
                values.put("FIRST_SOURCE_FILE", "src/" + f.replace('\\', '/'));
                first = false;
            }
            sources = sources + "  src/" + f;
            xml_sources = xml_sources + "      <File RelativePath=\".\\src\\" + f.replace('/', '\\') + "\"/>\n";
            vs10_sources = vs10_sources + "    <ClCompile Include=\".\\src\\" + f.replace('/', '\\') + "\"/>\n";
        }
        values.put("PROJECT_SOURCES", sources);
        values.put("PROJECT_XML_SOURCES", xml_sources);
        values.put("PROJECT_VS10_SOURCES", vs10_sources);
        FileUtils.FilterWrapper wrapper = new FileUtils.FilterWrapper(){

            public Reader getReader(Reader reader) {
                StringSearchInterpolator propertiesInterpolator = new StringSearchInterpolator("@", "@");
                propertiesInterpolator.addValueSource((ValueSource)new MapBasedValueSource(values));
                propertiesInterpolator.setEscapeString("\\");
                InterpolatorFilterReader interpolatorFilterReader = new InterpolatorFilterReader(reader, (Interpolator)propertiesInterpolator, "@", "@");
                interpolatorFilterReader.setInterpolateWithPrefixPattern(false);
                return interpolatorFilterReader;
            }
        };
        return new FileUtils.FilterWrapper[]{wrapper};
    }
}

