/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.fusesource.mvnplugins.graph.ProjectMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectReportMojo
extends ProjectMojo
implements MavenReport {
    private File outputDirectory;
    private List<MavenProject> reactorProjects;

    public boolean canGenerateReport() {
        return true;
    }

    public String getOutputName() {
        return "dependency-graph";
    }

    public String getName(Locale locale) {
        return "Dependency Graph";
    }

    public String getDescription(Locale locale) {
        return "Visual graph of the maven dependencies";
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public void setReportOutputDirectory(File file) {
        this.outputDirectory = file;
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            this.getLog().info((CharSequence)this.project.getModules().toString());
            if (this.project.getModules().size() > 1 && this.reactorProjects != null) {
                this.hideExternal = true;
            }
            this.execute();
            sink.figure();
            sink.figureGraphics(this.getOutputName() + ".png");
            sink.figure_();
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Could not generate graph.", (Exception)((Object)e));
        }
    }

    @Override
    protected void collectProjects(ArrayList<MavenProject> projects) {
        super.collectProjects(projects);
        if (this.project.getModules().size() > 1 && this.reactorProjects != null) {
            projects.addAll(this.reactorProjects);
        }
    }

    @Override
    public File getTarget() {
        return new File(this.outputDirectory, this.getOutputName() + ".png");
    }
}

