/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.fusesource.mvnplugins.uberize.Transformer;
import org.fusesource.mvnplugins.uberize.UberEntry;
import org.fusesource.mvnplugins.uberize.Uberizer;
import org.fusesource.mvnplugins.uberize.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUberizer
extends AbstractLogEnabled
implements Uberizer {
    private final HashMap<String, String> classRelocations = new HashMap();
    private final HashMap<File, File> extractionMapping = new HashMap();
    private Transformer currentTransformer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uberize(File targetDir, Set sourceJars, File uberJar, List<Filter> filters, List<Transformer> transformers) throws IOException {
        String id;
        this.classRelocations.clear();
        this.extractionMapping.clear();
        this.currentTransformer = null;
        targetDir = targetDir.getCanonicalFile();
        targetDir.mkdirs();
        FileUtils.cleanDirectory((File)targetDir);
        String jarMappingTxt = new File(targetDir, "jar-mapping.txt").getPath();
        String transformMappingTxt = new File(targetDir, "transformation-mapping.txt").getPath();
        TreeMap<String, UberEntry> tree = new TreeMap<String, UberEntry>();
        this.getLogger().info("Extracting jars...");
        for (File jar : sourceJars) {
            int counter = 1;
            id = jar.getName();
            File workDir = new File(targetDir, id);
            while (workDir.exists()) {
                id = jar.getName() + "." + counter++;
                workDir = new File(targetDir, id);
            }
            this.extractionMapping.put(workDir, jar);
            FileUtils.fileAppend((String)jarMappingTxt, (String)(id + "=" + jar.getPath() + "\n"));
            List<Filter> jarFilters = this.getFilters(jar, filters);
            JarFile jarFile = new JarFile(jar);
            try {
                Enumeration<JarEntry> j = jarFile.entries();
                while (j.hasMoreElements()) {
                    JarEntry entry = j.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || this.isFiltered(jarFilters, name)) continue;
                    InputStream is = jarFile.getInputStream(entry);
                    File extracted = DefaultUberizer.writeFile(workDir, name, is);
                    this.getNode(tree, name).getSources().add(extracted);
                }
            }
            finally {
                jarFile.close();
            }
        }
        int transformerCounter = 0;
        for (Transformer transformer : transformers) {
            this.getLogger().info("Applying transformer: " + transformer.getClass().getName());
            this.currentTransformer = transformer;
            id = "transformer-" + transformerCounter++;
            File xformWorkDir = new File(targetDir, id);
            FileUtils.fileAppend((String)transformMappingTxt, (String)(id + "=" + transformer.getClass().getName() + "\n"));
            transformer.process(this, xformWorkDir, tree);
        }
        boolean ok = true;
        for (UberEntry entry : new ArrayList(tree.values())) {
            if (entry.getSources().isEmpty()) {
                tree.remove(entry.getPath());
                continue;
            }
            this.pickOneSource(tree, entry);
        }
        this.getLogger().info("Uber jarring...");
        uberJar.getParentFile().mkdirs();
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(uberJar));
        HashSet<String> uberDirectories = new HashSet<String>();
        try {
            for (Map.Entry<String, UberEntry> entry : tree.entrySet()) {
                String path = entry.getKey();
                ArrayList<String> dirs = new ArrayList<String>();
                DefaultUberizer.getParentDirs(path, dirs);
                for (String dir : dirs) {
                    if (!uberDirectories.add(dir)) continue;
                    jos.putNextEntry(new JarEntry(dir));
                }
                jos.putNextEntry(new JarEntry(path));
                File file = entry.getValue().getSources().get(0);
                FileInputStream is = new FileInputStream(file);
                try {
                    IOUtil.copy((InputStream)is, (OutputStream)jos);
                }
                finally {
                    IOUtil.close((InputStream)is);
                }
            }
        }
        finally {
            IOUtil.close((OutputStream)jos);
        }
    }

    @Override
    public File pickOneSource(TreeMap<String, UberEntry> tree, UberEntry entry) throws IOException {
        if (entry.getSources().isEmpty()) {
            return null;
        }
        if (entry.getSources().size() > 1) {
            LinkedList<File> ignores = new LinkedList<File>(entry.getSources());
            File pick = ignores.removeFirst();
            if (this.isFileTypeThatCanIgnoreDuplicates(entry.getPath())) {
                Iterator i = ignores.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    if (!FileUtils.contentEquals((File)pick, (File)file)) continue;
                    i.remove();
                }
            }
            if (!ignores.isEmpty()) {
                String msgPrefix = "Overlapping sources for jar entry: ";
                if (this.currentTransformer != null) {
                    msgPrefix = this.currentTransformer.getClass().getSimpleName() + ": " + msgPrefix;
                }
                this.getLogger().warn("  " + msgPrefix + entry.getPath());
                this.getLogger().warn("    Picking source: " + this.originalJar(pick));
                for (File dup : ignores) {
                    this.getLogger().warn("    Ignoring source: " + this.originalJar(dup));
                }
            }
            entry = new UberEntry(entry).addSource(pick);
            tree.put(entry.getPath(), entry);
        }
        return entry.getSources().get(0);
    }

    private File originalJar(File source) throws IOException {
        String sourcePath = source.getCanonicalPath();
        for (File file : this.extractionMapping.keySet()) {
            if (!sourcePath.startsWith(file.getCanonicalPath() + File.separator)) continue;
            return this.extractionMapping.get(file);
        }
        return source;
    }

    private boolean isFileTypeThatCanIgnoreDuplicates(String path) {
        return path.endsWith(".class") | path.endsWith(".jpg") | path.endsWith(".gif") | path.endsWith(".png") | path.endsWith(".tiff") | path.endsWith(".jar") | path.endsWith(".zip") | path.endsWith(".tgz") | path.endsWith(".tar") | path.endsWith(".so") | path.endsWith(".dll") | path.endsWith(".dylib") | path.endsWith(".lib") | path.endsWith(".exe") | path.endsWith(".sh") | path.endsWith(".bat");
    }

    @Override
    public HashMap<String, String> getClassRelocations() {
        return this.classRelocations;
    }

    static void getParentDirs(String path, ArrayList<String> dirs) {
        if (path.length() < 2) {
            return;
        }
        int p = path.lastIndexOf("/", path.length() - 2);
        if (p > 0) {
            String dir = path.substring(0, p + 1);
            dirs.add(dir);
            DefaultUberizer.getParentDirs(dir, dirs);
        }
    }

    private UberEntry getNode(TreeMap<String, UberEntry> nodes, String path) {
        UberEntry node = nodes.get(path);
        if (node == null) {
            node = new UberEntry(path);
            nodes.put(path, node);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeFile(File basedir, String path, InputStream is) throws IOException {
        File file = DefaultUberizer.prepareFile(basedir, path);
        try {
            FileOutputStream os = new FileOutputStream(file);
            try {
                IOUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                IOUtil.close((OutputStream)os);
            }
        }
        finally {
            IOUtil.close((InputStream)is);
        }
        return file;
    }

    public static File prepareFile(File basedir, String path) throws IOException {
        File file = FileUtils.resolveFile((File)basedir, (String)path);
        if (!file.getCanonicalPath().startsWith(basedir.getCanonicalPath())) {
            throw new IOException("Bad output file name resolution: " + path);
        }
        file.getParentFile().mkdirs();
        return file;
    }

    private List<Filter> getFilters(File jar, List<Filter> filters) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = filters.get(i);
            if (!filter.canFilter(jar)) continue;
            list.add(filter);
        }
        return list;
    }

    private boolean isFiltered(List filters, String name) {
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = (Filter)filters.get(i);
            if (!filter.isFiltered(name)) continue;
            return true;
        }
        return false;
    }
}

