/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.fusesource.mvnplugins.uberize.Transformer;
import org.fusesource.mvnplugins.uberize.Uberizer;
import org.fusesource.mvnplugins.uberize.filter.SimpleFilter;
import org.fusesource.mvnplugins.uberize.mojo.ArchiveFilter;
import org.fusesource.mvnplugins.uberize.mojo.ArtifactSet;
import org.fusesource.mvnplugins.uberize.pom.PomWriter;
import org.fusesource.mvnplugins.uberize.transformer.ManifestEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UberizeMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private Uberizer uberizer;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    protected List remoteArtifactRepositories;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    private ArtifactSet artifactSet;
    private Transformer[] transformers;
    private ArchiveFilter[] filters;
    private File workDirectory;
    private File outputDirectory;
    private String finalName;
    private String uberArtifactId;
    private String uberGroupFilter;
    private boolean uberArtifactAttached;
    private boolean createDependencyReducedPom;
    private boolean keepDependenciesWithProvidedScope;
    private boolean promoteTransitiveDependencies;
    private String uberClassifierName;
    private boolean createSourcesJar;

    public void execute() throws MojoExecutionException {
        File file;
        LinkedHashSet<File> artifacts = new LinkedHashSet<File>();
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        LinkedHashSet<File> sourceArtifacts = new LinkedHashSet<File>();
        if (this.project.getArtifact().getFile() == null) {
            this.getLog().error((CharSequence)"The project main artifact does not exist. This could have the following");
            this.getLog().error((CharSequence)"reasons:");
            this.getLog().error((CharSequence)"- You have invoked the goal directly from the command line. This is not");
            this.getLog().error((CharSequence)"  supported. Please add the goal to the default lifecycle via an");
            this.getLog().error((CharSequence)"  <execution> element in your POM and use \"mvn package\" to have it run.");
            this.getLog().error((CharSequence)"- You have bound the goal to a lifecycle phase before \"package\". Please");
            this.getLog().error((CharSequence)"  remove this binding from your POM such that the goal will be run in");
            this.getLog().error((CharSequence)"  the proper phase.");
            throw new MojoExecutionException("Failed to create uber artifact.", (Exception)new IllegalStateException("Project main artifact does not exist."));
        }
        artifacts.add(this.project.getArtifact().getFile());
        if (this.createSourcesJar && (file = this.uberSourcesArtifactFile()).exists()) {
            sourceArtifacts.add(file);
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            File file2;
            if (this.excludeArtifact(artifact)) {
                this.getLog().info((CharSequence)("Excluding " + artifact.getId() + " from the uber jar."));
                continue;
            }
            this.getLog().info((CharSequence)("Including " + artifact.getId() + " in the uber jar."));
            artifacts.add(artifact.getFile());
            artifactIds.add(this.getId(artifact));
            if (!this.createSourcesJar || (file2 = this.resolveArtifactSources(artifact)) == null) continue;
            sourceArtifacts.add(file2);
        }
        File outputJar = this.uberArtifactFileWithClassifier();
        File sourcesJar = this.uberSourceArtifactFileWithClassifier();
        try {
            List filters = this.getFilters();
            List<Transformer> transformers = this.getTransformers();
            this.uberizer.uberize(this.workDirectory, artifacts, outputJar, filters, transformers);
            if (this.createSourcesJar) {
                this.uberizer.uberize(this.workDirectory, sourceArtifacts, sourcesJar, filters, transformers);
            }
            if (this.uberArtifactAttached) {
                this.getLog().info((CharSequence)"Attaching uber artifact.");
                this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.uberClassifierName, outputJar);
                if (this.createSourcesJar) {
                    this.projectHelper.attachArtifact(this.project, "jar", this.uberClassifierName + "-sources", sourcesJar);
                }
            } else {
                this.getLog().info((CharSequence)"Replacing original artifact with uber artifact.");
                File file3 = this.uberArtifactFile();
                this.replaceFile(file3, outputJar);
                if (this.createSourcesJar) {
                    file3 = this.uberSourcesArtifactFile();
                    this.replaceFile(file3, sourcesJar);
                    this.projectHelper.attachArtifact(this.project, "jar", "sources", file3);
                }
                if (this.createDependencyReducedPom) {
                    this.createDependencyReducedPom(artifactIds);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating uber jar.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceFile(File oldFile, File newFile) throws MojoExecutionException {
        FileInputStream fin;
        FileOutputStream fout;
        this.getLog().info((CharSequence)("Replacing " + oldFile + " with " + newFile));
        File origFile = new File(this.outputDirectory, "original-" + oldFile.getName());
        if (oldFile.exists() && !oldFile.renameTo(origFile)) {
            System.gc();
            System.gc();
            if (!oldFile.renameTo(origFile)) {
                try {
                    fout = new FileOutputStream(origFile);
                    fin = new FileInputStream(oldFile);
                    try {
                        IOUtil.copy((InputStream)fin, (OutputStream)fout);
                    }
                    finally {
                        IOUtil.close((InputStream)fin);
                        IOUtil.close((OutputStream)fout);
                    }
                }
                catch (IOException ex) {
                    this.getLog().warn((Throwable)ex);
                }
            }
        }
        if (!newFile.renameTo(oldFile)) {
            System.gc();
            System.gc();
            if (!newFile.renameTo(oldFile)) {
                try {
                    fout = new FileOutputStream(oldFile);
                    fin = new FileInputStream(newFile);
                    try {
                        IOUtil.copy((InputStream)fin, (OutputStream)fout);
                    }
                    finally {
                        IOUtil.close((InputStream)fin);
                        IOUtil.close((OutputStream)fout);
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Could not replace original artifact with uber artifact!", (Exception)ex);
                }
            }
        }
    }

    private File resolveArtifactSources(Artifact artifact) {
        Artifact resolvedArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "java-source", "sources");
        try {
            this.artifactResolver.resolve(resolvedArtifact, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ArtifactNotFoundException e) {
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Could not get sources for " + artifact));
        }
        if (resolvedArtifact.isResolved()) {
            return resolvedArtifact.getFile();
        }
        return null;
    }

    private boolean excludeArtifact(Artifact artifact) {
        String id = this.getId(artifact);
        if (this.artifactSet != null && this.artifactSet.getExcludes() == null && this.artifactSet.getIncludes() != null && !this.includedArtifacts().contains(id)) {
            return true;
        }
        if (this.excludedArtifacts().contains(id)) {
            return true;
        }
        return this.uberGroupFilter != null && !artifact.getGroupId().startsWith(this.uberGroupFilter);
    }

    private Set excludedArtifacts() {
        if (this.artifactSet != null && this.artifactSet.getExcludes() != null) {
            return this.artifactSet.getExcludes();
        }
        return Collections.EMPTY_SET;
    }

    private Set includedArtifacts() {
        if (this.artifactSet != null && this.artifactSet.getIncludes() != null) {
            return this.artifactSet.getIncludes();
        }
        return Collections.EMPTY_SET;
    }

    private List<Transformer> getTransformers() {
        List<Transformer> list = this.transformers == null ? Collections.EMPTY_LIST : Arrays.asList(this.transformers);
        ArrayList<Transformer> rc = new ArrayList<Transformer>(list);
        if (!this.containsTransformer(rc, ManifestEditor.class)) {
            rc.add(new ManifestEditor());
        }
        return rc;
    }

    private boolean containsTransformer(ArrayList<Transformer> rc, Class clazz) {
        for (Transformer transformer : rc) {
            if (!clazz.isAssignableFrom(transformer.getClass())) continue;
            return true;
        }
        return false;
    }

    private List getFilters() {
        ArrayList<SimpleFilter> filters = new ArrayList<SimpleFilter>();
        if (this.filters == null) {
            return filters;
        }
        HashMap<String, File> artifacts = new HashMap<String, File>();
        artifacts.put(this.getId(this.project.getArtifact()), this.project.getArtifact().getFile());
        for (Artifact artifact : this.project.getArtifacts()) {
            artifacts.put(this.getId(artifact), artifact.getFile());
        }
        for (int i = 0; i < this.filters.length; ++i) {
            ArchiveFilter f = this.filters[i];
            File jar = (File)artifacts.get(f.getArtifact());
            if (jar == null) {
                this.getLog().info((CharSequence)("No artifact matching filter " + f.getArtifact()));
                continue;
            }
            filters.add(new SimpleFilter(jar, f.getIncludes(), f.getExcludes()));
        }
        return filters;
    }

    private File uberArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String uberName = this.uberArtifactId + "-" + artifact.getVersion() + "-" + this.uberClassifierName + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, uberName);
    }

    private File uberSourceArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String uberName = this.uberArtifactId + "-" + artifact.getVersion() + "-" + this.uberClassifierName + "-sources." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, uberName);
    }

    private File uberArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        String uberName = this.finalName != null ? this.finalName + "." + artifact.getArtifactHandler().getExtension() : this.uberArtifactId + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, uberName);
    }

    private File uberSourcesArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        String uberName = this.finalName != null ? this.finalName + "-sources." + artifact.getArtifactHandler().getExtension() : this.uberArtifactId + "-" + artifact.getVersion() + "-sources." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, uberName);
    }

    private void createDependencyReducedPom(Set artifactsToRemove) throws IOException, DependencyTreeBuilderException, ProjectBuildingException {
        Model model = this.project.getOriginalModel();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        boolean modified = false;
        ArrayList<Dependency> transitiveDeps = new ArrayList<Dependency>();
        for (Artifact artifact : this.project.getArtifacts()) {
            Dependency dep = new Dependency();
            dep.setArtifactId(artifact.getArtifactId());
            if (artifact.hasClassifier()) {
                dep.setClassifier(artifact.getClassifier());
            }
            dep.setGroupId(artifact.getGroupId());
            dep.setOptional(artifact.isOptional());
            dep.setScope(artifact.getScope());
            dep.setType(artifact.getType());
            dep.setVersion(artifact.getVersion());
            transitiveDeps.add(dep);
        }
        ArrayList<Dependency> origDeps = this.project.getDependencies();
        if (this.promoteTransitiveDependencies) {
            origDeps = transitiveDeps;
        }
        for (Dependency d : origDeps) {
            dependencies.add(d);
            String id = d.getGroupId() + ":" + d.getArtifactId();
            if (!artifactsToRemove.contains(id)) continue;
            modified = true;
            if (this.keepDependenciesWithProvidedScope) {
                d.setScope("provided");
                continue;
            }
            dependencies.remove(d);
        }
        if (modified) {
            File f;
            while (modified) {
                model.setDependencies(dependencies);
                f = new File(this.outputDirectory, "dependency-reduced-pom.xml");
                if (f.exists()) {
                    f.delete();
                }
                XmlStreamWriter w = WriterFactory.newXmlWriter((File)f);
                PomWriter.write((Writer)w, model, true);
                w.close();
                MavenProject p2 = this.mavenProjectBuilder.build(f, this.localRepository, null);
                modified = this.updateExcludesInDeps(p2, dependencies, transitiveDeps);
            }
            f = new File(this.project.getBasedir(), "dependency-reduced-pom.xml");
            File f2 = new File(this.outputDirectory, "dependency-reduced-pom.xml");
            if (f.exists()) {
                f.delete();
            }
            FileUtils.copyFile((File)f2, (File)f);
            FileUtils.forceDeleteOnExit((File)f);
            this.project.setFile(f);
        }
    }

    private String getId(Artifact artifact) {
        if (artifact.getClassifier() == null || "jar".equals(artifact.getClassifier())) {
            return artifact.getGroupId() + ":" + artifact.getArtifactId();
        }
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getClassifier();
    }

    public boolean updateExcludesInDeps(MavenProject project, List dependencies, List transitiveDeps) throws DependencyTreeBuilderException {
        DependencyNode node = this.dependencyTreeBuilder.buildDependencyTree(project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector);
        boolean modified = false;
        ListIterator it = node.getChildren().listIterator();
        while (it.hasNext()) {
            DependencyNode n2 = (DependencyNode)it.next();
            ListIterator it2 = n2.getChildren().listIterator();
            block1: while (it2.hasNext()) {
                Dependency dep;
                int x;
                DependencyNode n3 = (DependencyNode)it2.next();
                if (n3.getState() != 0) continue;
                boolean found = false;
                for (x = 0; x < transitiveDeps.size(); ++x) {
                    dep = (Dependency)transitiveDeps.get(x);
                    if (!dep.getArtifactId().equals(n3.getArtifact().getArtifactId()) || !dep.getGroupId().equals(n3.getArtifact().getGroupId())) continue;
                    found = true;
                }
                if (found) continue;
                for (x = 0; x < dependencies.size(); ++x) {
                    dep = (Dependency)dependencies.get(x);
                    if (!dep.getArtifactId().equals(n2.getArtifact().getArtifactId()) || !dep.getGroupId().equals(n2.getArtifact().getGroupId())) continue;
                    Exclusion exclusion = new Exclusion();
                    exclusion.setArtifactId(n3.getArtifact().getArtifactId());
                    exclusion.setGroupId(n3.getArtifact().getGroupId());
                    dep.addExclusion(exclusion);
                    modified = true;
                    continue block1;
                }
            }
        }
        return modified;
    }
}

