/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.fusesource.stomp.jms.message.StompJmsMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageQueue {
    protected final long maxSize;
    protected final LinkedList<QueueEntry> list = new LinkedList();
    protected boolean closed;
    protected boolean running;
    protected long size;

    public MessageQueue(long maxSize) {
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(StompJmsMessage message) {
        QueueEntry entry = new QueueEntry(message, message.getFrame().size());
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.list.addLast(entry);
            this.size += (long)entry.size;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StompJmsMessage dequeue(long timeout) throws InterruptedException {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            while (!(timeout == 0L || this.closed || !this.list.isEmpty() && this.running)) {
                if (timeout == -1L) {
                    this.wait();
                    continue;
                }
                this.wait(timeout);
                break;
            }
            if (this.closed || !this.running || this.list.isEmpty()) {
                return null;
            }
            QueueEntry entry = this.list.removeFirst();
            this.size -= (long)entry.size;
            this.removed(entry);
            return entry.message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StompJmsMessage dequeueNoWait() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.closed || !this.running || this.list.isEmpty()) {
                return null;
            }
            QueueEntry entry = this.list.removeFirst();
            this.size -= (long)entry.size;
            this.removed(entry);
            return entry.message;
        }
    }

    protected void removed(QueueEntry entry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.running = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.running = false;
            this.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (!this.closed) {
                this.running = false;
                this.closed = true;
            }
            this.notifyAll();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StompJmsMessage> removeAll() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            ArrayList<StompJmsMessage> rc = new ArrayList<StompJmsMessage>(this.list.size());
            for (QueueEntry entry : this.list) {
                rc.add(entry.message);
            }
            this.list.clear();
            this.size = 0L;
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.list.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.size >= this.maxSize;
        }
    }

    protected static class QueueEntry {
        final StompJmsMessage message;
        final int size;

        QueueEntry(StompJmsMessage message, int size) {
            this.message = message;
            this.size = size;
        }
    }
}

