/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javafx.application.Application;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.CustomCssMetaData;
import org.fxmisc.richtext.CustomStyleableProperty;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.model.EditableStyledDocument;

public abstract class StyledTextField<PS, S>
extends StyledTextArea<PS, S> {
    private static final List<CssMetaData<? extends Styleable, ?>> CSS_META_DATA_LIST;
    private static final CssMetaData<StyledTextField, TextAlignment> TEXT_ALIGNMENT;
    private static final CssMetaData<StyledTextField, Paint> PROMPT_TEXT_FILL;
    private static final Pattern VERTICAL_WHITESPACE;
    private static final String STYLE_SHEET;
    private static final double HEIGHT;
    private boolean selectAll = true;
    private StyleableObjectProperty<TextAlignment> textAlignment;
    private StyleableObjectProperty<Paint> promptFillProp;
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

        protected void invalidated() {
            StyledTextField.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        public Object getBean() {
            return StyledTextField.this;
        }

        public String getName() {
            return "onAction";
        }
    };

    public StyledTextField(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> applyStyle, @NamedArg(value="document") EditableStyledDocument<PS, String, S> document) {
        super(initialParagraphStyle, applyParagraphStyle, initialTextStyle, applyStyle, document, true);
        this.getStylesheets().add((Object)STYLE_SHEET);
        this.getStyleClass().setAll((Object[])new String[]{"styled-text-field"});
        this.setAccessibleRole(AccessibleRole.TEXT_FIELD);
        this.setPrefSize(135.0, HEIGHT);
        this.addEventFilter(KeyEvent.KEY_PRESSED, KE -> {
            if (KE.getCode() == KeyCode.ENTER) {
                this.fireEvent((Event)new ActionEvent((Object)this, null));
                KE.consume();
            } else if (KE.getCode() == KeyCode.TAB) {
                this.traverse(this.getParent(), (Node)this, KE.isShiftDown() ? -1 : 1);
                KE.consume();
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, ME -> {
            this.selectAll = this.isFocused();
        });
        this.focusedProperty().addListener((ob, was, focused) -> {
            if (!was.booleanValue() && focused.booleanValue() && this.selectAll) {
                this.selectRange(this.getLength(), 0);
            } else if (!focused.booleanValue() && was.booleanValue()) {
                this.moveTo(0);
                this.requestFollowCaret();
            }
            this.selectAll = true;
        });
        super.setWrapText(false);
        this.wrapTextProperty().addListener((ob, ov, wrap) -> {
            if (wrap.booleanValue()) {
                this.wrapTextProperty().unbind();
                super.setWrapText(false);
            }
        });
    }

    private Node traverse(Parent p, Node from, int dir) {
        if (p == null) {
            return null;
        }
        ObservableList nodeList = p.getChildrenUnmodifiable();
        int len = nodeList.size();
        int neighbor = -1;
        if (from != null) {
            while (++neighbor < len && nodeList.get(neighbor) != from) {
            }
        } else {
            neighbor = dir == 1 ? -1 : len;
        }
        neighbor += dir;
        while (neighbor > -1 && neighbor < len) {
            Node target = (Node)nodeList.get(neighbor);
            if (target instanceof Pane || target instanceof Group) {
                if ((target = this.traverse((Parent)target, null, dir)) != null) {
                    return target;
                }
            } else if (target.isVisible() && !target.isDisabled() && target.isFocusTraversable()) {
                target.requestFocus();
                return target;
            }
            neighbor += dir;
        }
        return this.traverse(p.getParent(), (Node)p, dir);
    }

    public final ObjectProperty<TextAlignment> alignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new CustomStyleableProperty<TextAlignment>(TextAlignment.LEFT, "textAlignment", this, TEXT_ALIGNMENT);
            this.textAlignment.addListener((ob, ov, alignment) -> this.changeAlignment((TextAlignment)alignment));
        }
        return this.textAlignment;
    }

    public final TextAlignment getAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)this.textAlignment.getValue();
    }

    public final void setAlignment(TextAlignment value) {
        this.alignmentProperty().setValue((Object)value);
    }

    protected abstract void changeAlignment(TextAlignment var1);

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final void setOnAction(EventHandler<ActionEvent> value) {
        this.onActionProperty().set(value);
    }

    public final void setPromptText(Text value) {
        this.placeholderProperty().set((Object)value);
    }

    public final ObjectProperty<? super Text> promptTextProperty() {
        return this.placeholderProperty();
    }

    public final Text getPromptText() {
        return this.getPlaceholder() instanceof Text ? (Text)this.getPlaceholder() : null;
    }

    @Override
    public void setPlaceholder(Node value, Pos where) {
        throw new UnsupportedOperationException("Use setPromptText instead");
    }

    @Override
    protected void configurePlaceholder(Node placeholder) {
        placeholder.layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> (this.getHeight() - placeholder.getLayoutBounds().getHeight()) / 2.0 + Math.abs(placeholder.getLayoutBounds().getMinY()), (Observable[])new Observable[]{this.heightProperty(), placeholder.layoutBoundsProperty()}));
        placeholder.layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.calcHorizontalPos(), (Observable[])new Observable[]{this.widthProperty(), placeholder.layoutBoundsProperty(), this.paddingProperty(), this.alignmentProperty()}));
        if (placeholder instanceof Text && ((Text)placeholder).getFill() == Color.BLACK) {
            ((Text)placeholder).fillProperty().bind(this.promptTextFillProperty());
        }
    }

    private final ObjectProperty<Paint> promptTextFillProperty() {
        if (this.promptFillProp == null) {
            this.promptFillProp = new CustomStyleableProperty<Paint>((Paint)Color.GRAY, "promptFill", this, (CssMetaData<Styleable, Paint>)PROMPT_TEXT_FILL);
        }
        return this.promptFillProp;
    }

    private double calcHorizontalPos() {
        double leftPad = this.getPadding().getLeft();
        double rightPad = this.getPadding().getRight();
        double promptWidth = this.getPlaceholder().getLayoutBounds().getWidth();
        TextAlignment alignment = this.getAlignment();
        double alignmentPadding = leftPad;
        if (alignment == TextAlignment.RIGHT) {
            alignmentPadding = rightPad;
        } else if (alignment == TextAlignment.CENTER) {
            alignmentPadding = 0.0;
        }
        if (promptWidth < this.getWidth() - alignmentPadding) {
            this.setClip(null);
        } else {
            this.setClip((Node)new Rectangle(this.getWidth(), this.getHeight()));
        }
        switch (alignment) {
            case CENTER: {
                return (this.getWidth() - promptWidth) / 2.0;
            }
            case RIGHT: {
                return this.getWidth() - rightPad - promptWidth;
            }
        }
        return leftPad;
    }

    @Override
    public void replaceText(int start, int end, String text) {
        super.replaceText(start, end, VERTICAL_WHITESPACE.matcher(text).replaceAll(" "));
    }

    public void setText(String text) {
        this.replaceText(text);
    }

    @Override
    @Deprecated
    public void setWrapText(boolean value) {
    }

    @Override
    public boolean isWrapText() {
        return false;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    static {
        TEXT_ALIGNMENT = new CustomCssMetaData<StyledTextField, TextAlignment>("-fx-alignment", StyleConverter.getEnumConverter(TextAlignment.class), TextAlignment.LEFT, s -> (StyleableObjectProperty)s.alignmentProperty());
        PROMPT_TEXT_FILL = new CustomCssMetaData<StyledTextField, Color>("-fx-prompt-text-fill", StyleConverter.getPaintConverter(), Color.GRAY, s -> (StyleableObjectProperty)s.promptTextFillProperty());
        VERTICAL_WHITESPACE = Pattern.compile("\\v+");
        ArrayList styleables = new ArrayList(GenericStyledArea.getClassCssMetaData());
        styleables.add(PROMPT_TEXT_FILL);
        styleables.add(TEXT_ALIGNMENT);
        CSS_META_DATA_LIST = Collections.unmodifiableList(styleables);
        String globalCSS = System.getProperty("javafx.userAgentStylesheetUrl");
        if (globalCSS == null) {
            globalCSS = Application.getUserAgentStylesheet();
        }
        if (globalCSS == null) {
            globalCSS = "MODENA";
        }
        globalCSS = "styled-text-field-" + globalCSS.toLowerCase() + ".css";
        STYLE_SHEET = StyledTextField.class.getResource(globalCSS).toExternalForm();
        TextField tf = new TextField("GetHeight");
        new Scene((Parent)tf).snapshot(null);
        HEIGHT = tf.getHeight();
    }
}

