/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.EventStream;

public interface TextEditingArea<PS, SEG, S> {
    public int getLength();

    public ObservableValue<Integer> lengthProperty();

    public String getText();

    public ObservableValue<String> textProperty();

    public StyledDocument<PS, SEG, S> getDocument();

    public int getCaretPosition();

    public ObservableValue<Integer> caretPositionProperty();

    public int getAnchor();

    public ObservableValue<Integer> anchorProperty();

    public IndexRange getSelection();

    public ObservableValue<IndexRange> selectionProperty();

    public String getSelectedText();

    public ObservableValue<String> selectedTextProperty();

    public int getCurrentParagraph();

    public ObservableValue<Integer> currentParagraphProperty();

    public int getCaretColumn();

    public ObservableValue<Integer> caretColumnProperty();

    public ObservableList<Paragraph<PS, SEG, S>> getParagraphs();

    public EventStream<PlainTextChange> plainTextChanges();

    public EventStream<RichTextChange<PS, SEG, S>> richChanges();

    public String getText(int var1);

    public String getText(int var1, int var2);

    default public String getText(int startParagraph, int startColumn, int endParagraph, int endColumn) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        return this.getText(start, end);
    }

    public StyledDocument<PS, SEG, S> subDocument(int var1);

    public StyledDocument<PS, SEG, S> subDocument(int var1, int var2);

    default public StyledDocument<PS, SEG, S> subDocument(int startParagraph, int startColumn, int endParagraph, int endColumn) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        return this.subDocument(start, end);
    }

    public void selectRange(int var1, int var2);

    default public void selectRange(int anchorParagraph, int anchorColumn, int caretPositionParagraph, int caretPositionColumn) {
        int anchor = this.getAbsolutePosition(anchorParagraph, anchorColumn);
        int caretPosition = this.getAbsolutePosition(caretPositionParagraph, caretPositionColumn);
        this.selectRange(anchor, caretPosition);
    }

    public void replaceText(int var1, int var2, String var3);

    default public void replaceText(int startParagraph, int startColumn, int endParagraph, int endColumn, String text) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        this.replaceText(start, end, text);
    }

    public void replace(int var1, int var2, StyledDocument<PS, SEG, S> var3);

    default public void replace(int startParagraph, int startColumn, int endParagraph, int endColumn, StyledDocument<PS, SEG, S> replacement) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        this.replace(start, end, replacement);
    }

    default public void replaceText(IndexRange range, String text) {
        this.replaceText(range.getStart(), range.getEnd(), text);
    }

    default public void replace(IndexRange range, StyledDocument<PS, SEG, S> replacement) {
        this.replace(range.getStart(), range.getEnd(), replacement);
    }

    public int getAbsolutePosition(int var1, int var2);
}

