/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.collection.MaterializedListModification;
import org.reactfx.util.BiIndex;
import org.reactfx.util.Either;
import org.reactfx.util.FingerTree;
import org.reactfx.util.ToSemigroup;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuple3;
import org.reactfx.util.Tuples;

public final class ReadOnlyStyledDocument<PS, SEG, S>
implements StyledDocument<PS, SEG, S> {
    private static final Pattern LINE_TERMINATOR = Pattern.compile("\r\n|\r|\n");
    private static final BiFunction<Summary, Integer, Either<Integer, Integer>> NAVIGATE = (s, i) -> i <= s.length() ? Either.left((Object)i) : Either.right((Object)(i - (s.length() + 1)));
    private final FingerTree.NonEmptyFingerTree<Paragraph<PS, SEG, S>, Summary> tree;
    private String text = null;
    private List<Paragraph<PS, SEG, S>> paragraphs = null;

    private static <PS, SEG, S> ToSemigroup<Paragraph<PS, SEG, S>, Summary> summaryProvider() {
        return new ToSemigroup<Paragraph<PS, SEG, S>, Summary>(){

            public Summary apply(Paragraph<PS, SEG, S> p) {
                return new Summary(1, p.length());
            }

            public Summary reduce(Summary left, Summary right) {
                return new Summary(left.paragraphCount + right.paragraphCount, left.charCount + right.charCount);
            }
        };
    }

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> fromString(String str, PS paragraphStyle, S style, TextOps<SEG, S> segmentOps) {
        Matcher m = LINE_TERMINATOR.matcher(str);
        int n = 1;
        while (m.find()) {
            ++n;
        }
        ArrayList<Paragraph<PS, SEG, S>> res = new ArrayList<Paragraph<PS, SEG, S>>(n);
        int start = 0;
        m.reset();
        while (m.find()) {
            String s = str.substring(start, m.start());
            res.add(new Paragraph<PS, SEG, S>(paragraphStyle, segmentOps, segmentOps.create(s), style));
            start = m.end();
        }
        String last = str.substring(start);
        res.add(new Paragraph<PS, SEG, S>(paragraphStyle, segmentOps, segmentOps.create(last), style));
        return new ReadOnlyStyledDocument<PS, SEG, S>(res);
    }

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> fromSegment(SEG segment, PS paragraphStyle, S style, SegmentOps<SEG, S> segmentOps) {
        Paragraph<PS, SEG, S> content = new Paragraph<PS, SEG, S>(paragraphStyle, segmentOps, segment, style);
        List<Paragraph<PS, SEG, S>> res = Collections.singletonList(content);
        return new ReadOnlyStyledDocument<PS, SEG, S>(res);
    }

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> from(StyledDocument<PS, SEG, S> doc) {
        if (doc instanceof ReadOnlyStyledDocument) {
            return (ReadOnlyStyledDocument)doc;
        }
        return new ReadOnlyStyledDocument<PS, SEG, S>(doc.getParagraphs());
    }

    public static <PS, SEG, S> Codec<StyledDocument<PS, SEG, S>> codec(final Codec<PS> pCodec, final Codec<StyledSegment<SEG, S>> segCodec, final SegmentOps<SEG, S> segmentOps) {
        return new Codec<StyledDocument<PS, SEG, S>>(){
            private final Codec<List<Paragraph<PS, SEG, S>>> codec;
            {
                this.codec = Codec.listCodec(ReadOnlyStyledDocument.paragraphCodec(pCodec, segCodec, segmentOps));
            }

            @Override
            public String getName() {
                return "application/richtextfx-styled-document<" + pCodec.getName() + ";" + segCodec.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream os, StyledDocument<PS, SEG, S> doc) throws IOException {
                this.codec.encode(os, doc.getParagraphs());
            }

            @Override
            public StyledDocument<PS, SEG, S> decode(DataInputStream is) throws IOException {
                return new ReadOnlyStyledDocument(this.codec.decode(is));
            }
        };
    }

    private static <PS, SEG, S> Codec<Paragraph<PS, SEG, S>> paragraphCodec(final Codec<PS> pCodec, final Codec<StyledSegment<SEG, S>> segCodec, final SegmentOps<SEG, S> segmentOps) {
        return new Codec<Paragraph<PS, SEG, S>>(){
            private final Codec<List<StyledSegment<SEG, S>>> segmentsCodec;
            {
                this.segmentsCodec = Codec.listCodec(segCodec);
            }

            @Override
            public String getName() {
                return "paragraph<" + pCodec.getName() + ";" + segCodec.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream os, Paragraph<PS, SEG, S> p) throws IOException {
                pCodec.encode(os, p.getParagraphStyle());
                this.segmentsCodec.encode(os, p.getStyledSegments());
            }

            @Override
            public Paragraph<PS, SEG, S> decode(DataInputStream is) throws IOException {
                Object paragraphStyle = pCodec.decode(is);
                List segments = this.segmentsCodec.decode(is);
                return new Paragraph(paragraphStyle, segmentOps, segments);
            }
        };
    }

    private ReadOnlyStyledDocument(FingerTree.NonEmptyFingerTree<Paragraph<PS, SEG, S>, Summary> tree) {
        this.tree = tree;
    }

    ReadOnlyStyledDocument(List<Paragraph<PS, SEG, S>> paragraphs) {
        this.tree = (FingerTree.NonEmptyFingerTree)FingerTree.mkTree(paragraphs, ReadOnlyStyledDocument.summaryProvider()).caseEmpty().unify(emptyTree -> {
            throw new AssertionError((Object)"Unreachable code");
        }, neTree -> neTree);
    }

    @Override
    public int length() {
        return ((Summary)this.tree.getSummary()).length();
    }

    @Override
    public String getText() {
        if (this.text == null) {
            CharSequence[] strings = (String[])this.getParagraphs().stream().map(Paragraph::getText).toArray(String[]::new);
            this.text = String.join((CharSequence)"\n", strings);
        }
        return this.text;
    }

    public int getParagraphCount() {
        return this.tree.getLeafCount();
    }

    @Override
    public Paragraph<PS, SEG, S> getParagraph(int index) {
        return (Paragraph)this.tree.getLeaf(index);
    }

    @Override
    public List<Paragraph<PS, SEG, S>> getParagraphs() {
        if (this.paragraphs == null) {
            this.paragraphs = this.tree.asList();
        }
        return this.paragraphs;
    }

    @Override
    public TwoDimensional.Position position(int major, int minor) {
        return new Pos(major, minor);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int offset, TwoDimensional.Bias bias) {
        return this.position(0, 0).offsetBy(offset, bias);
    }

    public Tuple2<ReadOnlyStyledDocument<PS, SEG, S>, ReadOnlyStyledDocument<PS, SEG, S>> split(int position) {
        return (Tuple2)this.tree.locate(NAVIGATE, position).map(this::split);
    }

    public Tuple2<ReadOnlyStyledDocument<PS, SEG, S>, ReadOnlyStyledDocument<PS, SEG, S>> split(int paragraphIndex, int columnPosition) {
        return (Tuple2)this.tree.splitAt(paragraphIndex).map((l, p, r) -> {
            Paragraph p1 = p.trim(columnPosition);
            Paragraph p2 = p.subSequence(columnPosition);
            ReadOnlyStyledDocument doc1 = new ReadOnlyStyledDocument(l.append(p1));
            ReadOnlyStyledDocument doc2 = new ReadOnlyStyledDocument(r.prepend(p2));
            return Tuples.t(doc1, doc2);
        });
    }

    @Override
    public ReadOnlyStyledDocument<PS, SEG, S> concat(StyledDocument<PS, SEG, S> other) {
        return this.concat0(other, Paragraph::concat);
    }

    private ReadOnlyStyledDocument<PS, SEG, S> concatR(StyledDocument<PS, SEG, S> other) {
        return this.concat0(other, Paragraph::concatR);
    }

    private ReadOnlyStyledDocument<PS, SEG, S> concat0(StyledDocument<PS, SEG, S> other, BinaryOperator<Paragraph<PS, SEG, S>> parConcat) {
        int n = this.tree.getLeafCount() - 1;
        Paragraph p0 = (Paragraph)this.tree.getLeaf(n);
        Paragraph<PS, SEG, S> p1 = other.getParagraphs().get(0);
        Paragraph p = (Paragraph)parConcat.apply(p0, p1);
        FingerTree.NonEmptyFingerTree tree1 = this.tree.updateLeaf(n, (Object)p);
        FingerTree tree2 = other instanceof ReadOnlyStyledDocument ? (FingerTree)((ReadOnlyStyledDocument)other).tree.split((int)1)._2 : FingerTree.mkTree(other.getParagraphs().subList(1, other.getParagraphs().size()), ReadOnlyStyledDocument.summaryProvider());
        return new ReadOnlyStyledDocument<PS, SEG, S>(tree1.join(tree2));
    }

    @Override
    public StyledDocument<PS, SEG, S> subSequence(int start, int end) {
        return (StyledDocument)((ReadOnlyStyledDocument)this.split((int)end)._1).split((int)start)._2;
    }

    public Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replace(int from, int to, ReadOnlyStyledDocument<PS, SEG, S> replacement) {
        return this.replace(from, to, x -> replacement);
    }

    Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replace(int from, int to, UnaryOperator<ReadOnlyStyledDocument<PS, SEG, S>> f) {
        BiIndex start = this.tree.locate(NAVIGATE, from);
        BiIndex end = this.tree.locate(NAVIGATE, to);
        return this.replace(start, end, f);
    }

    Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replace(BiIndex start, BiIndex end, UnaryOperator<ReadOnlyStyledDocument<PS, SEG, S>> f) {
        int pos = this.tree.getSummaryBetween(0, start.major).map(s -> s.length() + 1).orElse(0) + start.minor;
        List removedPars = this.getParagraphs().subList(start.major, end.major + 1);
        return (Tuple3)((Tuple2)end.map(this::split)).map((l0, r) -> (Tuple3)((Tuple2)start.map(l0::split)).map((l, removed) -> {
            ReadOnlyStyledDocument replacement = (ReadOnlyStyledDocument)f.apply((ReadOnlyStyledDocument)removed);
            StyledDocument doc = l.concatR(replacement).concat((StyledDocument)r);
            RichTextChange change = new RichTextChange(pos, removed, replacement);
            List addedPars = ((ReadOnlyStyledDocument)doc).getParagraphs().subList(start.major, start.major + replacement.getParagraphCount());
            MaterializedListModification parChange = MaterializedListModification.create((int)start.major, (List)removedPars, addedPars);
            return Tuples.t((Object)doc, change, (Object)parChange);
        }));
    }

    Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replaceParagraph(int parIdx, UnaryOperator<Paragraph<PS, SEG, S>> f) {
        return this.replace(new BiIndex(parIdx, 0), new BiIndex(parIdx, ((Paragraph)this.tree.getLeaf(parIdx)).length()), doc -> doc.mapParagraphs(f));
    }

    ReadOnlyStyledDocument<PS, SEG, S> mapParagraphs(UnaryOperator<Paragraph<PS, SEG, S>> f) {
        int n = this.tree.getLeafCount();
        ArrayList<Paragraph<PS, SEG, S>> pars = new ArrayList<Paragraph<PS, SEG, S>>(n);
        for (int i = 0; i < n; ++i) {
            pars.add((Paragraph<PS, SEG, S>)f.apply((Paragraph<PS, SEG, S>)this.tree.getLeaf(i)));
        }
        return new ReadOnlyStyledDocument<PS, SEG, S>(pars);
    }

    public String toString() {
        return this.getParagraphs().stream().map(Paragraph::toString).reduce((p1, p2) -> p1 + "\n" + p2).orElse("");
    }

    public final boolean equals(Object other) {
        if (other instanceof StyledDocument) {
            StyledDocument that = (StyledDocument)other;
            return Objects.equals(this.getParagraphs(), that.getParagraphs());
        }
        return false;
    }

    public final int hashCode() {
        return this.getParagraphs().hashCode();
    }

    private class Pos
    implements TwoDimensional.Position {
        private final int major;
        private final int minor;

        private Pos(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public String toString() {
            return "(" + this.major + ", " + this.minor + ")";
        }

        @Override
        public boolean sameAs(TwoDimensional.Position other) {
            return this.getTargetObject() == other.getTargetObject() && this.major == other.getMajor() && this.minor == other.getMinor();
        }

        @Override
        public TwoDimensional getTargetObject() {
            return ReadOnlyStyledDocument.this;
        }

        @Override
        public int getMajor() {
            return this.major;
        }

        @Override
        public int getMinor() {
            return this.minor;
        }

        @Override
        public TwoDimensional.Position clamp() {
            if (this.major == ReadOnlyStyledDocument.this.tree.getLeafCount() - 1) {
                int elemLen = ((Paragraph)ReadOnlyStyledDocument.this.tree.getLeaf(this.major)).length();
                if (this.minor < elemLen) {
                    return this;
                }
                return new Pos(this.major, elemLen - 1);
            }
            return this;
        }

        @Override
        public TwoDimensional.Position offsetBy(int amount, TwoDimensional.Bias bias) {
            return (TwoDimensional.Position)ReadOnlyStyledDocument.this.tree.locateProgressively(s -> ((Summary)s).charCount + ((Summary)s).paragraphCount, this.toOffset() + amount).map((x$0, x$1) -> new Pos((int)x$0, (int)x$1));
        }

        @Override
        public int toOffset() {
            if (this.major == 0) {
                return this.minor;
            }
            return ((Summary)ReadOnlyStyledDocument.this.tree.getSummaryBetween(0, this.major).get()).length() + 1 + this.minor;
        }
    }

    private static class Summary {
        private final int paragraphCount;
        private final int charCount;

        public Summary(int paragraphCount, int charCount) {
            assert (paragraphCount > 0);
            assert (charCount >= 0);
            this.paragraphCount = paragraphCount;
            this.charCount = charCount;
        }

        public int length() {
            return this.charCount + this.paragraphCount - 1;
        }
    }
}

