/*
 * Decompiled with CFR 0.152.
 */
package org.galaxio.gatling.kafka.javaapi.checks;

import io.confluent.kafka.streams.serdes.avro.GenericAvroSerde;
import io.gatling.core.Predef$;
import io.gatling.core.check.Check;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.internal.CoreCheckType;
import java.io.Serializable;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.serialization.Serde;
import org.galaxio.gatling.kafka.checks.KafkaCheckMaterializer$;
import org.galaxio.gatling.kafka.javaapi.checks.KafkaCheckType;
import org.galaxio.gatling.kafka.request.KafkaProtocolMessage;
import scala.Function1;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;

public final class KafkaChecks$ {
    public static final KafkaChecks$ MODULE$ = new KafkaChecks$();
    private static final Serde<GenericRecord> avroSerde = new GenericAvroSerde();

    public Serde<GenericRecord> avroSerde() {
        return avroSerde;
    }

    private Check<KafkaProtocolMessage> toScalaCheck(Object javaCheck) {
        Object object = javaCheck;
        if (object instanceof CheckBuilder) {
            CheckBuilder checkBuilder = (CheckBuilder)javaCheck;
            io.gatling.core.check.CheckBuilder scalaCheck = checkBuilder.asScala();
            CheckBuilder.CheckType checkType = checkBuilder.type();
            if (CoreCheckType.BodyBytes.equals(checkType)) {
                return scalaCheck.build(KafkaCheckMaterializer$.MODULE$.bodyBytes());
            }
            if (CoreCheckType.BodyString.equals(checkType)) {
                return scalaCheck.build(KafkaCheckMaterializer$.MODULE$.bodyString(Predef$.MODULE$.configuration()));
            }
            if (CoreCheckType.Substring.equals(checkType)) {
                return scalaCheck.build(KafkaCheckMaterializer$.MODULE$.substring(Predef$.MODULE$.configuration()));
            }
            if (CoreCheckType.XPath.equals(checkType)) {
                return scalaCheck.build(KafkaCheckMaterializer$.MODULE$.xpath(Predef$.MODULE$.configuration()));
            }
            if (CoreCheckType.JsonPath.equals(checkType)) {
                return scalaCheck.build(KafkaCheckMaterializer$.MODULE$.jsonPath(Predef$.MODULE$.defaultJsonParsers(), Predef$.MODULE$.configuration()));
            }
            if (CoreCheckType.JmesPath.equals(checkType)) {
                return scalaCheck.build(KafkaCheckMaterializer$.MODULE$.jmesPath(Predef$.MODULE$.defaultJsonParsers(), Predef$.MODULE$.configuration()));
            }
            if (((Object)((Object)KafkaCheckType.ResponseCode)).equals(checkType)) {
                return scalaCheck.build(KafkaCheckMaterializer$.MODULE$.kafkaStatusCheck());
            }
            throw new IllegalArgumentException(new StringBuilder(26).append("Kafka DSL doesn't support ").append(checkType).toString());
        }
        throw new MatchError(object);
    }

    public Seq<Check<KafkaProtocolMessage>> toScalaChecks(List<Object> javaChecks) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(javaChecks).asScala().map((Function1 & Serializable)javaCheck -> MODULE$.toScalaCheck(javaCheck))).toSeq();
    }

    private KafkaChecks$() {
    }
}

