/*
 * Decompiled with CFR 0.152.
 */
package org.galaxio.gatling.kafka.javaapi;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.gatling.commons.validation.Validation;
import io.gatling.core.check.Check;
import io.gatling.core.check.CheckBuilder;
import io.gatling.core.check.CheckMaterializer;
import io.gatling.core.session.Session;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.internal.Expressions;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.galaxio.gatling.kafka.Predef;
import org.galaxio.gatling.kafka.javaapi.checks.KafkaCheckType;
import org.galaxio.gatling.kafka.javaapi.checks.KafkaChecks;
import org.galaxio.gatling.kafka.javaapi.protocol.KafkaProtocolBuilderBase;
import org.galaxio.gatling.kafka.javaapi.request.builder.KafkaRequestBuilderBase;
import org.galaxio.gatling.kafka.javaapi.request.expressions.Builders;
import org.galaxio.gatling.kafka.javaapi.request.expressions.ExpressionBuilder;
import org.galaxio.gatling.kafka.javaapi.request.expressions.JExpression;
import org.galaxio.gatling.kafka.request.KafkaProtocolMessage;
import scala.Function1;

public final class KafkaDsl {
    public static <T> JExpression<T> cf(T t) {
        return session -> t;
    }

    public static ExpressionBuilder<String> stringExp(JExpression<String> jExpression) {
        return new Builders.StringExpressionBuilder(jExpression);
    }

    public static ExpressionBuilder<String> stringExp(String string) {
        return KafkaDsl.stringExp(KafkaDsl.cf(string));
    }

    public static ExpressionBuilder<Float> floatExp(JExpression<Float> jExpression) {
        return new Builders.FloatExpressionBuilder(jExpression);
    }

    public static ExpressionBuilder<Float> floatExp(Float f) {
        return KafkaDsl.floatExp(KafkaDsl.cf(f));
    }

    public static ExpressionBuilder<Double> doubleExp(JExpression<Double> jExpression) {
        return new Builders.DoubleExpressionBuilder(jExpression);
    }

    public static ExpressionBuilder<Double> doubleExp(Double d) {
        return KafkaDsl.doubleExp(KafkaDsl.cf(d));
    }

    public static ExpressionBuilder<Short> shortExp(JExpression<Short> jExpression) {
        return new Builders.ShortExpressionBuilder(jExpression);
    }

    public static ExpressionBuilder<Short> shortExp(Short s) {
        return KafkaDsl.shortExp(KafkaDsl.cf(s));
    }

    public static ExpressionBuilder<Integer> integerExp(JExpression<Integer> jExpression) {
        return new Builders.IntegerExpressionBuilder(jExpression);
    }

    public static ExpressionBuilder<Integer> integerExp(Integer n) {
        return KafkaDsl.integerExp(KafkaDsl.cf(n));
    }

    public static ExpressionBuilder<Long> longExp(JExpression<Long> jExpression) {
        return new Builders.LongExpressionBuilder(jExpression);
    }

    public static ExpressionBuilder<Long> longExp(Long l) {
        return KafkaDsl.longExp(KafkaDsl.cf(l));
    }

    public static ExpressionBuilder<ByteBuffer> byteBufferExp(JExpression<ByteBuffer> jExpression) {
        return new Builders.ByteBufferExpressionBuilder(jExpression);
    }

    public static ExpressionBuilder<ByteBuffer> byteBufferExp(ByteBuffer byteBuffer) {
        return KafkaDsl.byteBufferExp(KafkaDsl.cf(byteBuffer));
    }

    public static ExpressionBuilder<byte[]> byteArrayExp(byte[] byArray) {
        return KafkaDsl.byteArrayExp(KafkaDsl.cf(byArray));
    }

    public static ExpressionBuilder<byte[]> byteArrayExp(JExpression<byte[]> jExpression) {
        return new Builders.ByteArrayExpressionBuilder(jExpression);
    }

    public static ExpressionBuilder<Bytes> bytesExp(JExpression<Bytes> jExpression) {
        return new Builders.BytesExpressionBuilder(jExpression);
    }

    public static ExpressionBuilder<Bytes> bytesExp(Bytes bytes) {
        return KafkaDsl.bytesExp(KafkaDsl.cf(bytes));
    }

    public static Builders.AvroExpressionBuilder avro(Object object, SchemaRegistryClient schemaRegistryClient) {
        return KafkaDsl.avro(KafkaDsl.cf(object), schemaRegistryClient);
    }

    public static Builders.AvroExpressionBuilder avro(JExpression<Object> jExpression, SchemaRegistryClient schemaRegistryClient) {
        return new Builders.AvroExpressionBuilder(jExpression, schemaRegistryClient);
    }

    public static Builders.AvroExpressionBuilder avro(JExpression<Object> jExpression, Serializer<Object> serializer, Deserializer<Object> deserializer) {
        return new Builders.AvroExpressionBuilder(jExpression, serializer, deserializer);
    }

    public static KafkaProtocolBuilderBase kafka() {
        return new KafkaProtocolBuilderBase();
    }

    public static KafkaRequestBuilderBase kafka(String string) {
        return new KafkaRequestBuilderBase(Predef.kafka((Function1<Session, Validation<String>>)Expressions.toStringExpression((String)string)), string);
    }

    public static CheckBuilder simpleCheck(final Function<KafkaProtocolMessage, Boolean> function) {
        return new CheckBuilder(){

            public io.gatling.core.check.CheckBuilder<?, ?> asScala() {
                return new io.gatling.core.check.CheckBuilder(){

                    public Check<?> build(CheckMaterializer checkMaterializer) {
                        return new KafkaChecks.SimpleChecksScala().simpleCheck((Function1<KafkaProtocolMessage, Object>)((Function1)function::apply));
                    }
                };
            }

            public CheckBuilder.CheckType type() {
                return KafkaCheckType.Simple;
            }
        };
    }

    public static CheckBuilder.Find<Object, KafkaProtocolMessage, GenericRecord> avroBody() {
        return new KafkaChecks.SimpleChecksScala().avroBody(KafkaChecks.avroSerde());
    }
}

