/*
 * Decompiled with CFR 0.152.
 */
package org.galaxio.gatling.kafka.javaapi.request.expressions;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.nio.ByteBuffer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.galaxio.gatling.kafka.javaapi.request.expressions.ExpressionBuilder;
import org.galaxio.gatling.kafka.javaapi.request.expressions.JExpression;

public class Builders {

    public static final class AvroExpressionBuilder
    extends ExpressionBuilder<Object> {
        public AvroExpressionBuilder(JExpression<Object> jExpression, SchemaRegistryClient schemaRegistryClient) {
            super(jExpression, Object.class, Serdes.serdeFrom((Serializer)new KafkaAvroSerializer(schemaRegistryClient), (Deserializer)new KafkaAvroDeserializer(schemaRegistryClient)));
        }

        public AvroExpressionBuilder(JExpression<Object> jExpression, Serializer<Object> serializer, Deserializer<Object> deserializer) {
            super(jExpression, Object.class, Serdes.serdeFrom(serializer, deserializer));
        }
    }

    public static final class StringExpressionBuilder
    extends ExpressionBuilder<String> {
        public StringExpressionBuilder(JExpression<String> jExpression) {
            super(jExpression, String.class, Serdes.String());
        }
    }

    public static final class BytesExpressionBuilder
    extends ExpressionBuilder<Bytes> {
        public BytesExpressionBuilder(JExpression<Bytes> jExpression) {
            super(jExpression, Bytes.class, Serdes.Bytes());
        }
    }

    public static final class ByteBufferExpressionBuilder
    extends ExpressionBuilder<ByteBuffer> {
        public ByteBufferExpressionBuilder(JExpression<ByteBuffer> jExpression) {
            super(jExpression, ByteBuffer.class, Serdes.ByteBuffer());
        }
    }

    public static final class ByteArrayExpressionBuilder
    extends ExpressionBuilder<byte[]> {
        public ByteArrayExpressionBuilder(JExpression<byte[]> jExpression) {
            super(jExpression, byte[].class, Serdes.ByteArray());
        }
    }

    public static final class LongExpressionBuilder
    extends ExpressionBuilder<Long> {
        public LongExpressionBuilder(JExpression<Long> jExpression) {
            super(jExpression, Long.class, Serdes.Long());
        }
    }

    public static final class IntegerExpressionBuilder
    extends ExpressionBuilder<Integer> {
        public IntegerExpressionBuilder(JExpression<Integer> jExpression) {
            super(jExpression, Integer.class, Serdes.Integer());
        }
    }

    public static final class ShortExpressionBuilder
    extends ExpressionBuilder<Short> {
        public ShortExpressionBuilder(JExpression<Short> jExpression) {
            super(jExpression, Short.class, Serdes.Short());
        }
    }

    public static final class DoubleExpressionBuilder
    extends ExpressionBuilder<Double> {
        public DoubleExpressionBuilder(JExpression<Double> jExpression) {
            super(jExpression, Double.class, Serdes.Double());
        }
    }

    public static final class FloatExpressionBuilder
    extends ExpressionBuilder<Float> {
        public FloatExpressionBuilder(JExpression<Float> jExpression) {
            super(jExpression, Float.class, Serdes.Float());
        }
    }
}

