/*
 * Decompiled with CFR 0.152.
 */
package org.galaxio.gatling.kafka.javaapi.request.expressions;

import io.gatling.commons.validation.Validation;
import io.gatling.core.session.Session;
import io.gatling.javaapi.core.internal.Expressions;
import org.apache.kafka.common.serialization.Serde;
import org.galaxio.gatling.kafka.javaapi.request.expressions.JExpression;
import scala.Function1;

public abstract class ExpressionBuilder<V> {
    private final JExpression<V> javaExpression;
    private final Class<V> type;
    private final Serde<V> serde;

    protected ExpressionBuilder(JExpression<V> jExpression, Class<V> clazz, Serde<V> serde) {
        this.javaExpression = jExpression;
        this.type = clazz;
        this.serde = serde;
    }

    Function1<Session, Validation<byte[]>> bytes(String string) {
        return Expressions.javaFunctionToExpression(this.javaExpression.andThen(object -> this.serde.serializer().serialize(string, object)));
    }

    public Function1<Session, Validation<V>> gatlingExpression() {
        return Expressions.javaFunctionToExpression(this.javaExpression);
    }

    public Class<V> getType() {
        return this.type;
    }

    public Serde<V> getSerde() {
        return this.serde;
    }
}

