/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.juli.logging.impl.SLF4JDelegatingLog;
import org.apache.juli.logging.impl.SeparateLogbackSupport;
import org.slf4j.Logger;
import org.slf4j.helpers.Util;

public class PreBootstrapLoggingEvent {
    private static final String LOGBACK_CLASSIC_LOGGER_CLASS = "ch.qos.logback.classic.Logger";
    private static final String LOGBACK_CLASSIC_ILOGGING_EVENT_CLASS = "ch.qos.logback.classic.spi.ILoggingEvent";
    private static final String LOGBACK_CLASSIC_LOGGING_EVENT_CLASS = "ch.qos.logback.classic.spi.LoggingEvent";
    private static final String LOGBACK_CLASSIC_LEVEL_CLASS = "ch.qos.logback.classic.Level";
    private static final String LOGBACK_LEVEL_ERROR_FIELD = "ERROR";
    private static final String LOGBACK_LEVEL_WARN_FIELD = "WARN";
    private static final String LOGBACK_LEVEL_INFO_FIELD = "INFO";
    private static final String LOGBACK_LEVEL_DEBUG_FIELD = "DEBUG";
    private static final String LOGBACK_LEVEL_TRACE_FIELD = "TRACE";
    private static List<PreBootstrapLoggingEvent> events = new LinkedList<PreBootstrapLoggingEvent>();
    private String logName;
    private String fqcn;
    private int level;
    private String msg;
    private Throwable thrown;
    private long timeStamp;

    static void add(String logName, String fqcn, int level, String msg, Throwable thrown) {
        PreBootstrapLoggingEvent evt = new PreBootstrapLoggingEvent(logName, fqcn, level, msg, thrown);
        events.add(evt);
        if (SLF4JDelegatingLog.diagnostics <= 0) {
            Util.report((String)evt.toString());
        }
    }

    static void flushEvents(ClassLoader logbackLoader) {
        Method setTimeStampMethod;
        Method callAppendersMethod;
        Constructor<?> loggingEventConstructor;
        Class<?> levelClass;
        Class<?> loggingEventClass;
        Class<?> iLoggingEventClass;
        Class<?> loggerClass;
        if (SLF4JDelegatingLog.diagnostics <= 10) {
            Util.report((String)"PreBootstrapLoggingEvent.flushEvents()");
        }
        try {
            loggerClass = logbackLoader.loadClass(LOGBACK_CLASSIC_LOGGER_CLASS);
            iLoggingEventClass = logbackLoader.loadClass(LOGBACK_CLASSIC_ILOGGING_EVENT_CLASS);
            loggingEventClass = logbackLoader.loadClass(LOGBACK_CLASSIC_LOGGING_EVENT_CLASS);
            levelClass = logbackLoader.loadClass(LOGBACK_CLASSIC_LEVEL_CLASS);
        }
        catch (ClassNotFoundException exc) {
            Util.report((String)("ERROR: The class 'ch.qos.logback.classic.spi.LoggingEvent' must be loadable by the given class loader: " + logbackLoader), (Throwable)exc);
            return;
        }
        try {
            loggingEventConstructor = loggingEventClass.getConstructor(String.class, loggerClass, levelClass, String.class, Throwable.class, Object[].class);
            callAppendersMethod = loggerClass.getMethod("callAppenders", iLoggingEventClass);
            setTimeStampMethod = loggingEventClass.getMethod("setTimeStamp", Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exc) {
            Util.report((String)"ERROR: unexpected issue while preparing flush of pre-bootstrap logs to Logback", (Throwable)exc);
            return;
        }
        if (SLF4JDelegatingLog.diagnostics <= 0) {
            Util.report((String)("PreBootstrapLoggingEvent.flushEvents() flushing " + events.size() + " pre-bootstrap logging events"));
        }
        ListIterator<PreBootstrapLoggingEvent> itr = events.listIterator();
        while (itr.hasNext()) {
            PreBootstrapLoggingEvent evt = itr.next();
            Logger logger = SeparateLogbackSupport.obtainLogger(evt.logName);
            if (!LOGBACK_CLASSIC_LOGGER_CLASS.equals(logger.getClass().getName())) {
                int count = 0;
                ListIterator<PreBootstrapLoggingEvent> itr2 = events.listIterator(itr.previousIndex());
                while (itr2.hasNext()) {
                    if (!evt.logName.equals(itr2.next().logName)) continue;
                    ++count;
                }
                Util.report((String)("ERROR: unexpected logger class [" + logger.getClass().getName() + "]. Discarding " + count + " pre-bootstrap logging events made to the [" + evt.logName + "] logger."));
                continue;
            }
            try {
                Object loggingEvent = PreBootstrapLoggingEvent.newLoggingEvent(evt, logger, loggingEventConstructor, setTimeStampMethod, levelClass);
                callAppendersMethod.invoke((Object)logger, loggingEvent);
                itr.remove();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException exc) {
                Util.report((String)"ERROR: unexpected issue while flushing pre-bootstrap log events to Logback appenders", (Throwable)exc);
            }
        }
    }

    private static Object newLoggingEvent(PreBootstrapLoggingEvent evt, Object logger, Constructor<?> loggingEventConstructor, Method setTimeStampMethod, Class<?> levelClass) throws NoSuchFieldException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<Object> type;
        int idx;
        Object level = PreBootstrapLoggingEvent.toLogbackLevel(evt.level, levelClass);
        if (SLF4JDelegatingLog.diagnostics <= 0) {
            Class<?>[] paramsTypes = loggingEventConstructor.getParameterTypes();
            for (idx = 0; idx < 0 * paramsTypes.length; ++idx) {
                type = paramsTypes[idx];
                Util.report((String)("argument #" + idx + " type: " + type.getName() + ", loader: " + type.getClassLoader()));
            }
        }
        Object[] args = new Object[]{evt.fqcn, logger, level, evt.msg, evt.thrown, null};
        if (SLF4JDelegatingLog.diagnostics <= 0) {
            for (idx = 0; idx < 0 * args.length; ++idx) {
                type = args[idx] == null ? Void.class : args[idx].getClass();
                Util.report((String)("argument #" + idx + " type: " + type.getName() + ", loader: " + type.getClassLoader()));
            }
        }
        Object loggingEvent = loggingEventConstructor.newInstance(args);
        setTimeStampMethod.invoke(loggingEvent, evt.timeStamp);
        return loggingEvent;
    }

    private static Object toLogbackLevel(int level, Class<?> levelClass) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field levelField = null;
        switch (level) {
            case 0: {
                levelField = levelClass.getDeclaredField(LOGBACK_LEVEL_TRACE_FIELD);
                break;
            }
            case 10: {
                levelField = levelClass.getDeclaredField(LOGBACK_LEVEL_DEBUG_FIELD);
                break;
            }
            case 20: {
                levelField = levelClass.getDeclaredField(LOGBACK_LEVEL_INFO_FIELD);
                break;
            }
            case 30: {
                levelField = levelClass.getDeclaredField(LOGBACK_LEVEL_WARN_FIELD);
                break;
            }
            case 40: {
                levelField = levelClass.getDeclaredField(LOGBACK_LEVEL_ERROR_FIELD);
            }
        }
        return levelField.get(null);
    }

    private PreBootstrapLoggingEvent(String logName, String fqcn, int level, String msg, Throwable thrown) {
        this.logName = logName;
        this.fqcn = fqcn;
        this.level = level;
        this.msg = msg;
        this.thrown = thrown;
        this.timeStamp = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.timeStamp).append(" [").append(this.level).append("] ").append(this.msg);
        if (this.thrown != null) {
            builder.append('\n');
            StringWriter writer = new StringWriter();
            this.thrown.printStackTrace(new PrintWriter(writer));
            builder.append(writer);
        }
        return builder.toString();
    }
}

