/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi.contexts;

import javax.inject.Inject;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.exoplatform.portal.pc.aspects.PortletLifecyclePhaseInterceptor;
import org.gatein.cdi.CDIPortletContextExtension;
import org.gatein.cdi.contexts.CDIPortletContext;
import org.gatein.cdi.contexts.PortletRedisplayedContext;
import org.gatein.cdi.contexts.PortletRequestLifecycle;

public class CDIServletListener
implements ServletRequestListener,
HttpSessionListener {
    @Inject
    private CDIPortletContextExtension extension;

    public void requestInitialized(ServletRequestEvent event) {
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        String windowId = PortletLifecyclePhaseInterceptor.currentWindowId();
        String phase = PortletLifecyclePhaseInterceptor.currentPhase();
        if (phase != null) {
            for (CDIPortletContext context : this.extension.getContexts()) {
                context.transition(request, windowId, PortletRequestLifecycle.State.starting(phase));
            }
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        String windowId = PortletLifecyclePhaseInterceptor.currentWindowId();
        String phase = PortletLifecyclePhaseInterceptor.currentPhase();
        if (phase != null) {
            for (CDIPortletContext context : this.extension.getContexts()) {
                context.transition(request, windowId, PortletRequestLifecycle.State.ending(phase));
            }
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        PortletRedisplayedContext context = this.extension.getContext(PortletRedisplayedContext.class);
        if (context != null) {
            context.dissociate(event.getSession());
        }
    }
}

