/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi.contexts.beanstore;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.gatein.cdi.contexts.beanstore.LockedBean;

public class LockStore {
    static final String SESSION_KEY = LockStore.class.getName();
    private volatile transient Map<String, ReferenceCountedLock> locks = new HashMap<String, ReferenceCountedLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockedBean lock(String id) {
        ReferenceCountedLock refLock;
        Map<String, ReferenceCountedLock> map = this.locks;
        synchronized (map) {
            if (this.locks == null) {
                this.locks = new HashMap<String, ReferenceCountedLock>();
            }
            if ((refLock = this.locks.get(id)) != null) {
                ++refLock.count;
            } else {
                refLock = new ReferenceCountedLock(id);
                this.locks.put(id, refLock);
            }
        }
        refLock.lock.lock();
        return refLock;
    }

    private class ReferenceCountedLock
    implements LockedBean {
        private final String key;
        int count = 1;
        final ReentrantLock lock = new ReentrantLock();

        private ReferenceCountedLock(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            Map map = LockStore.this.locks;
            synchronized (map) {
                this.lock.unlock();
                --this.count;
                if (this.count == 0) {
                    LockStore.this.locks.remove(this.key);
                }
            }
        }
    }
}

