/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gatein.management.api.PathAddressIterator;
import org.gatein.management.api.PathTemplateResolver;

public class PathAddress
implements Iterable<String> {
    public static final PathAddress EMPTY_ADDRESS = new PathAddress(Collections.<String>emptyList());
    List<String> pathList;
    private List<PathTemplateResolver> resolvers;

    public static PathAddress empty() {
        return EMPTY_ADDRESS;
    }

    public static PathAddress pathAddress(String ... paths) {
        if (paths == null) {
            throw new IllegalArgumentException("paths is null");
        }
        return new PathAddress(Arrays.asList(paths));
    }

    public static PathAddress pathAddress(String addressPath) {
        if (addressPath == null) {
            throw new IllegalArgumentException("addressString is null");
        }
        if (addressPath.charAt(0) == '/') {
            addressPath = addressPath.substring(1, addressPath.length());
        }
        return new PathAddress(Arrays.asList(addressPath.split("/")));
    }

    PathAddress(List<String> pathList) {
        this(pathList, new ArrayList<PathTemplateResolver>());
    }

    PathAddress(List<String> pathList, List<PathTemplateResolver> resolvers) {
        this.pathList = pathList;
        this.resolvers = resolvers;
    }

    public PathAddress append(String path) {
        return this.append(PathAddress.pathAddress(path));
    }

    public PathAddress append(PathAddress address) {
        ArrayList<String> list = new ArrayList<String>(this.pathList.size() + address.pathList.size());
        list.addAll(this.pathList);
        list.addAll(address.pathList);
        return new PathAddress(list, new ArrayList<PathTemplateResolver>(this.resolvers));
    }

    public PathAddress subAddress(int start) {
        return new PathAddress(this.pathList.subList(start, this.pathList.size()));
    }

    public PathAddress subAddress(int start, int end) {
        return new PathAddress(this.pathList.subList(start, end));
    }

    public String getLastElement() {
        return this.pathList.size() == 0 ? null : this.pathList.get(this.pathList.size() - 1);
    }

    public String get(int index) {
        return this.pathList.get(index);
    }

    public String resolvePathTemplate(String templateName) {
        for (PathTemplateResolver resolver : this.resolvers) {
            String resolved = resolver.resolve(templateName);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    public void addPathTemplateResolver(PathTemplateResolver resolver) {
        this.resolvers.add(resolver);
    }

    public List<PathTemplateResolver> getPathTemplateResolvers() {
        return Collections.unmodifiableList(this.resolvers);
    }

    public PathAddressIterator iterator() {
        return new PathAddressIterator(this);
    }

    public int size() {
        return this.pathList.size();
    }

    public PathAddress copy() {
        return new PathAddress(new ArrayList<String>(this.pathList), new ArrayList<PathTemplateResolver>(this.resolvers));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathAddress that = (PathAddress)o;
        return ((Object)this.pathList).equals(that.pathList);
    }

    public int hashCode() {
        return ((Object)this.pathList).hashCode();
    }

    public String toString() {
        PathAddressIterator iterator = this.iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            sb.append("/").append((String)iterator.next());
        }
        return sb.toString();
    }
}

