/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.api.controller;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.PathAddress;

public interface ManagedRequest {
    public String getOperationName();

    public PathAddress getAddress();

    public Map<String, List<String>> getAttributes();

    public InputStream getDataStream();

    public ContentType getContentType();

    public static class Factory {
        public static ManagedRequest create(String operationName, PathAddress address, ContentType contentType) {
            return Factory.create(operationName, address, Collections.<String, List<String>>emptyMap(), contentType);
        }

        public static ManagedRequest create(String operationName, PathAddress address, Map<String, List<String>> attributes, ContentType contentType) {
            return Factory.create(operationName, address, attributes, null, contentType);
        }

        public static ManagedRequest create(String operationName, PathAddress address, InputStream data, ContentType contentType) {
            return Factory.create(operationName, address, Collections.<String, List<String>>emptyMap(), data, contentType);
        }

        public static ManagedRequest create(final String operationName, final PathAddress address, final Map<String, List<String>> attributes, final InputStream dataStream, final ContentType contentType) {
            return new ManagedRequest(){

                @Override
                public String getOperationName() {
                    return operationName;
                }

                @Override
                public PathAddress getAddress() {
                    return address;
                }

                @Override
                public Map<String, List<String>> getAttributes() {
                    return attributes;
                }

                @Override
                public InputStream getDataStream() {
                    return dataStream;
                }

                @Override
                public ContentType getContentType() {
                    return contentType;
                }
            };
        }
    }
}

