/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.cli.crash.commands.scp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jcr.Session;
import org.apache.sshd.server.Environment;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.ssh.term.AbstractCommand;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.ssh.term.scp.SCPAction;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.controller.ManagementController;
import org.gatein.management.cli.crash.commands.scp.SCPCommand;

public abstract class SCPCommand
extends AbstractCommand
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SCPCommand.class);
    private String path;
    private String containerName;
    private SCPManagementCommand scpManagementCommand;
    private Thread thread;

    protected SCPCommand(SCPAction action) {
        this.parseSCPAction(action);
    }

    public void start(Environment environment) throws IOException {
        try {
            this.scpManagementCommand = new SCPManagementCommand();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        this.thread = new Thread((Runnable)this, "CRaSH");
        this.thread.start();
    }

    public void destroy() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int status = 0;
        String exitMessage = null;
        try {
            this.execute();
        }
        catch (Throwable t) {
            log.error((Object)"Exception during command execution.", t);
            status = 11;
            exitMessage = t.getMessage();
        }
        finally {
            if (this.callback != null) {
                this.callback.onExit(status, exitMessage + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() throws Exception {
        Session jcrSession = null;
        String userName = (String)this.session.getAttribute(SSHLifeCycle.USERNAME);
        String password = (String)this.session.getAttribute(SSHLifeCycle.PASSWORD);
        log.debug((Object)("Attempting to authenticate user " + userName));
        jcrSession = this.scpManagementCommand.login(userName, password, this.containerName);
        if (jcrSession == null) {
            throw new Exception("JCR session was null.");
        }
        this.scpManagementCommand.start(this.containerName);
        try {
            this.execute((ManagementController)this.scpManagementCommand.getComponent(this.containerName, ManagementController.class), this.path);
        }
        finally {
            this.scpManagementCommand.end();
            if (jcrSession.isLive()) {
                jcrSession.logout();
            }
        }
    }

    protected abstract void execute(ManagementController var1, String var2) throws Exception;

    protected String getFileName() {
        int index = this.path.lastIndexOf("/");
        if (index != -1) {
            return this.path.substring(index + 1, this.path.length());
        }
        return this.path;
    }

    protected String[] trim(String[] array) {
        return this.scpManagementCommand.trim(array);
    }

    protected void ack() throws IOException {
        this.out.write(0);
        this.out.flush();
    }

    protected void readAck() throws IOException {
        int c = this.in.read();
        switch (c) {
            case 0: {
                break;
            }
            case 1: {
                log.debug((Object)("Received warning: " + this.readLine()));
                break;
            }
            case 2: {
                throw new IOException("Received nack: " + this.readLine());
            }
        }
    }

    protected String readLine() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c = this.in.read()) != 10) {
            if (c == -1) {
                throw new IOException("End of stream");
            }
            baos.write(c);
        }
        return baos.toString();
    }

    private void parseSCPAction(SCPAction action) {
        String target = action.getTarget();
        int pos1 = target.indexOf(58);
        if (pos1 != -1) {
            this.containerName = target.substring(0, pos1);
            this.path = target.substring(pos1 + 1);
        } else {
            this.containerName = "portal";
            this.path = target;
        }
        if (this.path.charAt(0) == '/') {
            this.path = this.path.substring(1);
        }
    }
}

