/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.cli.crash.commands.scp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.crsh.ssh.term.scp.SCPAction;
import org.crsh.util.IO;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.controller.ManagedRequest;
import org.gatein.management.api.controller.ManagedResponse;
import org.gatein.management.api.controller.ManagementController;
import org.gatein.management.cli.crash.commands.scp.SCPCommand;

public class SourceCommand
extends SCPCommand {
    protected SourceCommand(SCPAction action) {
        super(action);
    }

    protected void execute(ManagementController controller, String path) throws Exception {
        ManagedResponse response = this.getResponse(controller, path);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        response.writeResult((OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
        this.out.write("C0644 ".getBytes());
        this.out.write(Integer.toString(outputStream.size()).getBytes());
        this.out.write(" ".getBytes());
        this.out.write(this.getFileName().getBytes());
        this.out.write("\n".getBytes());
        this.out.flush();
        this.readAck();
        IO.copy((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), (OutputStream)this.out);
        this.ack();
        this.readAck();
    }

    private ManagedResponse getResponse(ManagementController controller, String path) {
        String operationName = "export-resource";
        ContentType contentType = ContentType.ZIP;
        if (path.endsWith(".xml")) {
            operationName = "read-config-as-xml";
            contentType = ContentType.XML;
            path = path.substring(0, path.lastIndexOf(".xml"));
        } else if (path.endsWith(".zip")) {
            path = path.substring(0, path.lastIndexOf(".zip"));
        }
        return controller.execute(ManagedRequest.Factory.create((String)operationName, (PathAddress)PathAddress.pathAddress((String[])this.trim(path.split("/"))), (ContentType)contentType));
    }
}

