/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.cli.crash.commands;

import java.lang.reflect.Method;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.command.CRaSHCommand;
import org.crsh.command.ScriptException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class GateInCommand
extends CRaSHCommand {
    private static final Logger log = LoggerFactory.getLogger(GateInCommand.class);

    protected GateInCommand() throws IntrospectionException {
    }

    protected <T> T getComponent(String containerName, Class<T> componentClass) throws ScriptException {
        Object container = this.getContainer(containerName);
        try {
            Method getComponentInstanceOfTypeMethod = container.getClass().getMethod("getComponentInstanceOfType", Class.class);
            return componentClass.cast(getComponentInstanceOfTypeMethod.invoke(container, componentClass));
        }
        catch (Exception e) {
            log.error((Object)("Exception retrieving component of type " + componentClass), (Throwable)e);
            return null;
        }
    }

    protected Session login(String userName, String password, String containerName) throws ScriptException {
        Object container = this.getContainer(containerName);
        try {
            Method getComponentInstanceOfTypeMethod = container.getClass().getMethod("getComponentInstanceOfType", Class.class);
            Class<?> repositoryServiceClass = Thread.currentThread().getContextClassLoader().loadClass("org.exoplatform.services.jcr.RepositoryService");
            Object repositoryService = getComponentInstanceOfTypeMethod.invoke(container, repositoryServiceClass);
            if (repositoryService != null) {
                SimpleCredentials credentials;
                Method getCurrentRepositoryMethod = repositoryService.getClass().getMethod("getCurrentRepository", new Class[0]);
                Repository repository = (Repository)getCurrentRepositoryMethod.invoke(repositoryService, new Object[0]);
                Session session = repository.login((Credentials)(credentials = new SimpleCredentials(userName, password.toCharArray())), "portal-system");
                if (session == null) {
                    throw new Exception("JCR Session was null.");
                }
                session.getRootNode();
                return session;
            }
            throw new Exception("Repository service was null.");
        }
        catch (Exception e) {
            throw new ScriptException("Could not authenticate for user '" + userName + "'", (Throwable)e);
        }
    }

    protected void start(String containerName) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> requestLifeCycleClass = cl.loadClass("org.exoplatform.container.component.RequestLifeCycle");
            Class<?> exoContainerClass = cl.loadClass("org.exoplatform.container.ExoContainer");
            Method beginMethod = requestLifeCycleClass.getMethod("begin", exoContainerClass);
            beginMethod.invoke(requestLifeCycleClass, this.getContainer(containerName));
        }
        catch (Exception e) {
            throw new ScriptException("Could not start gatein request lifecycle.", (Throwable)e);
        }
    }

    protected void end() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> requestLifeCycleClass = cl.loadClass("org.exoplatform.container.component.RequestLifeCycle");
            Method endMethod = requestLifeCycleClass.getMethod("end", new Class[0]);
            endMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new ScriptException("Could not end gatein request lifecycle.", (Throwable)e);
        }
    }

    private Object getContainer(String containerName) throws ScriptException {
        Object container;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> eXoContainerContextClass = cl.loadClass("org.exoplatform.container.ExoContainerContext");
            Method getTopContainerMethod = eXoContainerContextClass.getMethod("getTopContainer", new Class[0]);
            container = getTopContainerMethod.invoke(null, new Object[0]);
            if (container != null) {
                Method getPortalContainerMethod = container.getClass().getMethod("getPortalContainer", String.class);
                container = getPortalContainerMethod.invoke(container, containerName);
            }
        }
        catch (Exception e) {
            throw new ScriptException("Could not obtain portal container for container name " + containerName, (Throwable)e);
        }
        if (container == null) {
            throw new ScriptException("Could not obtain portal container for container name " + containerName);
        }
        return container;
    }
}

