/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.cli.crash.commands.scp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Session;
import org.apache.sshd.server.Environment;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.ssh.term.AbstractCommand;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.ssh.term.scp.SCPAction;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.controller.ManagementController;
import org.gatein.management.cli.crash.commands.scp.SCPCommand;

public abstract class SCPCommand
extends AbstractCommand
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SCPCommand.class);
    private String path;
    private String containerName;
    private SCPManagementCommand scpManagementCommand;
    private Thread thread;
    private static final String REGEX = "([\\w\\.-]*):(.*)";
    private static final Pattern PATTERN = Pattern.compile("([\\w\\.-]*):(.*)");

    protected SCPCommand(SCPAction action) {
        this.parseSCPAction(action);
    }

    public void start(Environment environment) throws IOException {
        try {
            this.scpManagementCommand = new SCPManagementCommand();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        this.thread = new Thread((Runnable)this, "CRaSH");
        this.thread.start();
    }

    public void destroy() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int status = 0;
        String exitMessage = null;
        try {
            this.execute();
        }
        catch (Throwable t) {
            log.error((Object)"Exception during command execution.", t);
            status = 11;
            exitMessage = t.getMessage();
        }
        finally {
            if (this.callback != null) {
                this.callback.onExit(status, exitMessage + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() throws Exception {
        String userName = (String)this.session.getAttribute(SSHLifeCycle.USERNAME);
        String password = (String)this.session.getAttribute(SSHLifeCycle.PASSWORD);
        log.debug((Object)("Attempting to authenticate user " + userName));
        Session jcrSession = this.scpManagementCommand.login(userName, password, this.containerName);
        if (jcrSession == null) {
            throw new Exception("JCR session was null.");
        }
        this.scpManagementCommand.start(this.containerName);
        try {
            HashMap<String, ArrayList<String>> attributes = new HashMap<String, ArrayList<String>>();
            if (this.path.contains("?")) {
                String query = this.path.substring(this.path.indexOf("?") + 1, this.path.length());
                this.path = this.path.substring(0, this.path.indexOf("?"));
                try {
                    for (String q : query.split("&")) {
                        String[] param = q.split("=");
                        if (param.length != 2) {
                            throw new Exception();
                        }
                        ArrayList<String> values = (ArrayList<String>)attributes.get(param[0]);
                        if (values == null) {
                            values = new ArrayList<String>();
                            attributes.put(param[0], values);
                        }
                        values.add(param[1]);
                    }
                }
                catch (Exception e) {
                    throw new Exception("Could not parse attribute query: " + query);
                }
            }
            ManagementController controller = (ManagementController)this.scpManagementCommand.getComponent(this.containerName, ManagementController.class);
            this.execute(controller, this.path, attributes);
        }
        finally {
            this.scpManagementCommand.end();
            if (jcrSession.isLive()) {
                jcrSession.logout();
            }
        }
    }

    protected abstract void execute(ManagementController var1, String var2, Map<String, List<String>> var3) throws Exception;

    protected String getFileName() {
        int index = this.path.lastIndexOf("/");
        if (index != -1) {
            return this.path.substring(index + 1, this.path.length());
        }
        return this.path;
    }

    protected void ack() throws IOException {
        this.out.write(0);
        this.out.flush();
    }

    protected void readAck() throws IOException {
        int c = this.in.read();
        switch (c) {
            case 0: {
                break;
            }
            case 1: {
                log.debug((Object)("Received warning: " + this.readLine()));
                break;
            }
            case 2: {
                throw new IOException("Received nack: " + this.readLine());
            }
        }
    }

    protected String readLine() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c = this.in.read()) != 10) {
            if (c == -1) {
                throw new IOException("End of stream");
            }
            baos.write(c);
        }
        return baos.toString();
    }

    private void parseSCPAction(SCPAction action) {
        String target = action.getTarget();
        Matcher matcher = PATTERN.matcher(target);
        if (matcher.matches()) {
            this.containerName = matcher.group(1);
            this.path = matcher.group(2);
        } else {
            this.containerName = "portal";
            this.path = target;
        }
        if (this.path.charAt(0) == '/') {
            this.path = this.path.substring(1);
        }
    }
}

