/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.naming.context;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.gatein.naming.context.SecurityActions;
import org.gatein.naming.util.NamingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactoryBuilder
implements javax.naming.spi.ObjectFactoryBuilder,
ObjectFactory {
    public static final ObjectFactoryBuilder INSTANCE = new ObjectFactoryBuilder();

    private ObjectFactoryBuilder() {
    }

    @Override
    public ObjectFactory createObjectFactory(Object obj, Hashtable<?, ?> environment) throws NamingException {
        try {
            if (obj instanceof Reference) {
                return this.factoryFromReference((Reference)obj, environment);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        if (classLoader == null) {
            return ref;
        }
        String factoriesProp = (String)environment.get("java.naming.factory.object");
        if (factoriesProp != null) {
            String[] classes;
            for (String className : classes = factoriesProp.split(":")) {
                try {
                    Class<?> factoryClass = classLoader.loadClass(className);
                    ObjectFactory objectFactory = (ObjectFactory)ObjectFactory.class.cast(factoryClass.newInstance());
                    Object result = objectFactory.getObjectInstance(ref, name, nameCtx, environment);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private ObjectFactory factoryFromReference(Reference reference, Hashtable<?, ?> environment) throws Exception {
        return this.factoryFromReference(reference, SecurityActions.getContextClassLoader(), environment);
    }

    private ObjectFactory factoryFromReference(Reference reference, ClassLoader classLoader, Hashtable<?, ?> environment) throws Exception {
        try {
            Class<?> factoryClass = classLoader.loadClass(reference.getFactoryClassName());
            ObjectFactory factory = (ObjectFactory)ObjectFactory.class.cast(factoryClass.newInstance());
            return factory;
        }
        catch (Throwable t) {
            throw NamingUtils.namingException("Failed to create object factory from classloader.", t);
        }
    }
}

