/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.gatein.naming.FailoverNamingContext;
import org.gatein.naming.NamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverInitialContextFactory
implements InitialContextFactory {
    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        InitialContext failover;
        String factory = System.getProperty("org.gatein.naming.fallback.factory");
        if (factory != null) {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("java.naming.factory.initial", factory);
            String url = System.getProperty("org.gatein.naming.fallback.url");
            if (url != null) {
                params.put("java.naming.provider.url", url);
            }
            failover = new InitialContext(params);
        } else {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("java.naming.factory.initial", "org.jboss.as.naming.InitialContextFactory");
            failover = new InitialContext(params);
        }
        return new FailoverNamingContext(failover, new NamingContext(environment));
    }
}

