/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.naming.util;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingUtils {
    private NamingUtils() {
    }

    private static Context createSubcontext(Context ctx, Name name) throws NamingException {
        Context subctx = ctx;
        for (int pos = 0; pos < name.size(); ++pos) {
            String ctxName = name.get(pos);
            try {
                subctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                subctx = ctx.createSubcontext(ctxName);
            }
            ctx = subctx;
        }
        return subctx;
    }

    public static String getLastComponent(Name name) {
        if (name.size() > 0) {
            return name.get(name.size() - 1);
        }
        return "";
    }

    public static boolean isEmpty(Name name) {
        return name.isEmpty() || name.size() == 1 && "".equals(name.get(0));
    }

    public static boolean isLastComponentEmpty(Name name) {
        return name.isEmpty() || NamingUtils.getLastComponent(name).equals("");
    }

    public static NameNotFoundException nameNotFoundException(String name, Name contextName) {
        return new NameNotFoundException(String.format("Name '%s' not found in context '%s'", name, contextName.toString()));
    }

    public static NameAlreadyBoundException nameAlreadyBoundException(Name name) {
        return new NameAlreadyBoundException(name.toString());
    }

    public static InvalidNameException emptyNameException() {
        return new InvalidNameException("An empty name is not allowed");
    }

    public static NotContextException notAContextException(Name name) {
        return new NotContextException(name.toString());
    }

    public static NamingException namingException(String message, Throwable cause) {
        NamingException exception = new NamingException(message);
        if (cause != null) {
            exception.initCause(cause);
        }
        return exception;
    }

    public static NamingException namingException(String message, Throwable cause, Name remainingName) {
        NamingException exception = NamingUtils.namingException(message, cause);
        exception.setRemainingName(remainingName);
        return exception;
    }

    public static CannotProceedException cannotProceedException(Object resolvedObject, Name remainingName) {
        CannotProceedException cpe = new CannotProceedException();
        cpe.setResolvedObj(resolvedObject);
        cpe.setRemainingName(remainingName);
        return cpe;
    }

    public static <T> NamingEnumeration<T> namingEnumeration(Collection<T> collection) {
        final Iterator<T> iterator = collection.iterator();
        return new NamingEnumeration<T>(){

            @Override
            public T next() {
                return this.nextElement();
            }

            @Override
            public boolean hasMore() {
                return this.hasMoreElements();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static void rebind(Context ctx, String name, Object value) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        NamingUtils.rebind(ctx, n, value);
    }

    public static void rebind(Context ctx, Name name, Object value) throws NamingException {
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = NamingUtils.createSubcontext(ctx, name.getPrefix(size - 1));
        parentCtx.rebind(atom, value);
    }

    public static void unbind(Context ctx, String name) throws NamingException {
        NamingUtils.unbind(ctx, ctx.getNameParser("").parse(name));
    }

    public static void unbind(Context ctx, Name name) throws NamingException {
        ctx.unbind(name);
        int sz = name.size();
        while (--sz > 0) {
            Name pname = name.getPrefix(sz);
            try {
                ctx.destroySubcontext(pname);
            }
            catch (NamingException e) {
                break;
            }
        }
    }
}

