/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.naming;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.gatein.naming.util.FastCopyHashMap;

final class AtomicMapFieldUpdater<C, K, V> {
    private final AtomicReferenceFieldUpdater<C, Map<K, V>> updater;

    public static <C, K, V> AtomicMapFieldUpdater<C, K, V> newMapUpdater(AtomicReferenceFieldUpdater<C, Map> updater) {
        return new AtomicMapFieldUpdater<C, K, V>(updater);
    }

    AtomicMapFieldUpdater(AtomicReferenceFieldUpdater<C, Map> updater) {
        this.updater = updater;
    }

    public void clear(C instance) {
        this.updater.set(instance, Collections.emptyMap());
    }

    public V get(C instance, Object key) {
        return this.updater.get(instance).get(key);
    }

    public V put(C instance, K key, V value) {
        V oldValue;
        Map<K, V> newMap;
        Map<K, V> oldMap;
        boolean result;
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        do {
            int oldSize;
            if ((oldSize = (oldMap = this.updater.get(instance)).size()) == 0) {
                oldValue = null;
                newMap = Collections.singletonMap(key, value);
                continue;
            }
            if (oldSize == 1) {
                Map.Entry<K, V> entry = oldMap.entrySet().iterator().next();
                K oldKey = entry.getKey();
                if (oldKey.equals(key)) {
                    newMap = Collections.singletonMap(key, value);
                    oldValue = entry.getValue();
                    continue;
                }
                newMap = new FastCopyHashMap<K, V>(oldMap);
                oldValue = newMap.put(key, value);
                continue;
            }
            newMap = new FastCopyHashMap<K, V>(oldMap);
            oldValue = newMap.put(key, value);
        } while (!(result = this.updater.compareAndSet(instance, oldMap, newMap)));
        return oldValue;
    }

    public V putAtomic(C instance, K key, V value, Map<K, V> snapshot) {
        Map<K, V> newMap;
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        int oldSize = snapshot.size();
        if (oldSize == 0) {
            newMap = Collections.singletonMap(key, value);
        } else if (oldSize == 1) {
            Map.Entry<K, V> entry = snapshot.entrySet().iterator().next();
            K oldKey = entry.getKey();
            if (oldKey.equals(key)) {
                return entry.getValue();
            }
            newMap = new FastCopyHashMap<K, V>(snapshot);
            newMap.put(key, value);
        } else {
            newMap = new FastCopyHashMap<K, V>(snapshot);
            newMap.put(key, value);
        }
        if (this.updater.compareAndSet(instance, snapshot, newMap)) {
            return null;
        }
        return value;
    }

    public V putIfAbsent(C instance, K key, V value) {
        Map<K, V> newMap;
        Map<K, V> oldMap;
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        do {
            int oldSize;
            if ((oldSize = (oldMap = this.updater.get(instance)).size()) == 0) {
                newMap = Collections.singletonMap(key, value);
                continue;
            }
            if (oldSize == 1) {
                Map.Entry<K, V> entry = oldMap.entrySet().iterator().next();
                K oldKey = entry.getKey();
                if (oldKey.equals(key)) {
                    return entry.getValue();
                }
                newMap = new FastCopyHashMap<K, V>(oldMap);
                newMap.put(key, value);
                continue;
            }
            if (oldMap.containsKey(key)) {
                return oldMap.get(key);
            }
            newMap = new FastCopyHashMap<K, V>(oldMap);
            newMap.put(key, value);
        } while (!this.updater.compareAndSet(instance, oldMap, newMap));
        return null;
    }

    public V remove(C instance, K key) {
        V oldValue;
        Map<K, V> newMap;
        Map<K, V> oldMap;
        if (key == null) {
            return null;
        }
        do {
            int oldSize;
            if ((oldSize = (oldMap = this.updater.get(instance)).size()) == 0) {
                return null;
            }
            if (oldSize == 1) {
                Map.Entry<K, V> entry = oldMap.entrySet().iterator().next();
                if (entry.getKey().equals(key)) {
                    newMap = Collections.emptyMap();
                    oldValue = entry.getValue();
                    continue;
                }
                return null;
            }
            if (oldSize == 2) {
                Iterator<Map.Entry<K, V>> i = oldMap.entrySet().iterator();
                Map.Entry<K, V> entry = i.next();
                Map.Entry<K, V> next = i.next();
                if (entry.getKey().equals(key)) {
                    newMap = Collections.singletonMap(next.getKey(), next.getValue());
                    oldValue = entry.getValue();
                    continue;
                }
                if (next.getKey().equals(key)) {
                    newMap = Collections.singletonMap(entry.getKey(), entry.getValue());
                    oldValue = next.getValue();
                    continue;
                }
                return null;
            }
            if (!oldMap.containsKey(key)) {
                return null;
            }
            newMap = new FastCopyHashMap<K, V>(oldMap);
            oldValue = newMap.remove(key);
        } while (!this.updater.compareAndSet(instance, oldMap, newMap));
        return oldValue;
    }

    public Map<K, V> get(C subregistry) {
        return this.updater.get(subregistry);
    }

    public Map<K, V> getReadOnly(C subregistry) {
        Map<K, V> snapshot = this.updater.get(subregistry);
        return snapshot instanceof FastCopyHashMap ? Collections.unmodifiableMap(snapshot) : snapshot;
    }
}

