/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.management;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.management.PortletContainerManagementInterceptor;
import org.gatein.pc.management.PortletInfo;
import org.gatein.pc.portlet.PortletInvokerInterceptor;

public class PortletContainerManagementInterceptorImpl
extends PortletInvokerInterceptor
implements PortletContainerManagementInterceptor {
    private final ConcurrentMap<String, PortletInfo> map = new ConcurrentHashMap<String, PortletInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        PortletContext portlet = invocation.getTarget();
        String portletName = portlet.getId();
        boolean error = true;
        long delta = -System.currentTimeMillis();
        try {
            PortletInvocationResponse response = super.invoke(invocation);
            error = false;
            PortletInvocationResponse portletInvocationResponse = response;
            return portletInvocationResponse;
        }
        finally {
            delta += System.currentTimeMillis();
            if (invocation instanceof RenderInvocation) {
                PortletInfo info = this.getPortletInfo(portletName);
                info.newRenderCall(delta, error);
            } else if (invocation instanceof ActionInvocation) {
                PortletInfo info = this.getPortletInfo(portletName);
                info.newActionCall(delta, error);
            }
        }
    }

    public synchronized PortletInfo getPortletInfo(String key) {
        PortletInfo info = (PortletInfo)this.map.get(key);
        if (info == null) {
            info = this.map.putIfAbsent(key, new PortletInfo());
        }
        return (PortletInfo)this.map.get(key);
    }
}

