/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.rhq.plugins;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryCallback;

public class PortalDiscoveryCallback
implements ResourceDiscoveryCallback {
    private static final Log log = LogFactory.getLog((String)"org.gatein.rhq.plugins");
    private static final String CONFIG_PRODUCT_NAME = "expectedRuntimeProductName";
    private static final Map<String, String> productNameMap;

    public ResourceDiscoveryCallback.DiscoveryCallbackResults discoveredResources(DiscoveredResourceDetails discoveredResourceDetails) throws Exception {
        ResourceDiscoveryCallback.DiscoveryCallbackResults result = ResourceDiscoveryCallback.DiscoveryCallbackResults.UNPROCESSED;
        if (!this.isPortalServer(discoveredResourceDetails)) {
            return result;
        }
        boolean trace = log.isTraceEnabled();
        String version = discoveredResourceDetails.getResourceVersion();
        String name = discoveredResourceDetails.getResourceName();
        for (String v : productNameMap.keySet()) {
            if (!version.contains(v)) continue;
            String productName = productNameMap.get(v);
            if (trace) {
                String before = discoveredResourceDetails.getPluginConfiguration().getSimpleValue(CONFIG_PRODUCT_NAME);
                log.trace((Object)("Modifying expectedRuntimeProductName for resource [Name=" + name + ", Version=" + version + "] from '" + before + "' to '" + productName + "'"));
            }
            discoveredResourceDetails.getPluginConfiguration().setSimpleValue(CONFIG_PRODUCT_NAME, productName);
            result = ResourceDiscoveryCallback.DiscoveryCallbackResults.PROCESSED;
        }
        return result;
    }

    private boolean isPortalServer(DiscoveredResourceDetails details) {
        return details.getResourceName().startsWith("JPP");
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("6.1.1", "Portal");
        productNameMap = map;
    }
}

