/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.rhq.plugins;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gatein.rhq.plugins.VersionComparator;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryCallback;

public class PortalDiscoveryCallback
implements ResourceDiscoveryCallback {
    private static final Log log = LogFactory.getLog((String)"org.gatein.rhq.plugins");
    private static final String CONFIG_PRODUCT_NAME = "expectedRuntimeProductName";
    private static final String PRODUCT_NAME = "Portal";
    private static final String VERSION_RENAMED_TO_JBOSS_Portal = "6.1.1.GA";

    public ResourceDiscoveryCallback.DiscoveryCallbackResults discoveredResources(DiscoveredResourceDetails discoveredResourceDetails) throws Exception {
        ResourceDiscoveryCallback.DiscoveryCallbackResults result = ResourceDiscoveryCallback.DiscoveryCallbackResults.UNPROCESSED;
        if (!this.isPortalServer(discoveredResourceDetails)) {
            return result;
        }
        boolean trace = log.isTraceEnabled();
        String version = discoveredResourceDetails.getResourceVersion();
        String name = discoveredResourceDetails.getResourceName();
        if (VersionComparator.instance().compare(VERSION_RENAMED_TO_JBOSS_Portal, version) <= 0) {
            if (trace) {
                String before = discoveredResourceDetails.getPluginConfiguration().getSimpleValue(CONFIG_PRODUCT_NAME);
                log.trace((Object)("Modifying expectedRuntimeProductName for resource [Name=" + name + ", Version=" + version + "] from '" + before + "' to '" + PRODUCT_NAME + "'"));
            }
            discoveredResourceDetails.getPluginConfiguration().setSimpleValue(CONFIG_PRODUCT_NAME, PRODUCT_NAME);
            result = ResourceDiscoveryCallback.DiscoveryCallbackResults.PROCESSED;
        }
        return result;
    }

    private boolean isPortalServer(DiscoveredResourceDetails details) {
        return details.getResourceName().startsWith("JPP");
    }
}

