/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.rhq.plugins;

import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    private static final VersionComparator INSTANCE = new VersionComparator();
    public static final int DELIMITER = 46;
    public static final String DEFAULT_QUALIFIER = "GA";
    public static final int DEFAULT_NUMERIC_COMPONENT = 0;
    public static final int MAJOR_MINOR_MICRO = 3;

    public static VersionComparator instance() {
        return INSTANCE;
    }

    @Override
    public int compare(String version1, String version2) {
        VersionTokenizer t1 = new VersionTokenizer(version1, 3);
        VersionTokenizer t2 = new VersionTokenizer(version2, 3);
        for (int i = 0; i < 3; ++i) {
            int compare = Integer.compare(t1.nextInt(), t2.nextInt());
            if (compare == 0) continue;
            return compare;
        }
        return t1.rest().compareTo(t2.rest());
    }

    static class VersionTokenizer {
        private int position = 0;
        private final int length;
        private final String source;
        private int counter = 0;
        private final int numericComponentsCount;

        public VersionTokenizer(String source, int numericComponentsCount) {
            this.source = source;
            this.numericComponentsCount = numericComponentsCount;
            this.length = source.length();
        }

        private String next() {
            if (this.position >= this.length) {
                return null;
            }
            int end = this.source.indexOf(46, this.position);
            int start = this.position;
            if (end >= 0) {
                this.position = end + 1;
            } else {
                this.position = this.length;
                end = this.length;
            }
            return this.source.substring(start, end);
        }

        public int nextInt() {
            if (this.counter >= this.numericComponentsCount) {
                throw new IllegalStateException(this.getClass().getSimpleName() + ".nextInt() cannot be invoked more than " + this.numericComponentsCount + " times.");
            }
            ++this.counter;
            String token = this.next();
            if (token == null) {
                return 0;
            }
            int result = Integer.valueOf(token);
            if (result < 0) {
                throw new IllegalArgumentException("Version string '" + this.source + "' contains negative component " + result);
            }
            return result;
        }

        public String rest() {
            if (this.position >= this.length) {
                return VersionComparator.DEFAULT_QUALIFIER;
            }
            int start = this.position;
            this.position = this.length;
            return this.source.substring(start);
        }
    }
}

