/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.rhq.plugins;

public class ResourceKey {
    private static final String SEPARATOR = "@";
    private final String portalContainerName;
    private final String resourceName;

    public static ResourceKey create(String portalContainerName, String resourceName) {
        if (portalContainerName == null) {
            throw new IllegalArgumentException("portalContainerName cannot be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName cannot be null");
        }
        return new ResourceKey(portalContainerName, resourceName);
    }

    public static ResourceKey from(String compositeKey) {
        String[] parts = compositeKey.split(SEPARATOR);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid compositeKey " + compositeKey);
        }
        return ResourceKey.create(parts[0], parts[1]);
    }

    private ResourceKey(String portalContainerName, String resourceName) {
        this.resourceName = resourceName;
        this.portalContainerName = portalContainerName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getPortalContainerName() {
        return this.portalContainerName;
    }

    public String getDescription() {
        return "Resource for '" + this.resourceName + "' running in portal container '" + this.portalContainerName + "'";
    }

    public String toString() {
        return this.portalContainerName + SEPARATOR + this.resourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceKey siteKey = (ResourceKey)o;
        if (!this.portalContainerName.equals(siteKey.portalContainerName)) {
            return false;
        }
        return this.resourceName.equals(siteKey.resourceName);
    }

    public int hashCode() {
        int result = this.resourceName.hashCode();
        result = 31 * result + this.portalContainerName.hashCode();
        return result;
    }
}

