/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.rhq.plugins.jmx;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gatein.rhq.plugins.jmx.TemplateResolver;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public abstract class MBeanAttributeDiscoveryComponent
implements ResourceDiscoveryComponent<MBeanResourceComponent<?>> {
    private static final Log log = LogFactory.getLog((String)"org.gatein.rhq.plugins.jmx");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<MBeanResourceComponent<?>> context) throws InvalidPluginConfigurationException, Exception {
        Object object;
        EmsAttribute attribute;
        boolean trace = log.isTraceEnabled();
        Configuration config = context.getDefaultPluginConfiguration();
        String listAttributeName = config.getSimpleValue("listAttributeName", null);
        if (listAttributeName == null) {
            throw new InvalidPluginConfigurationException("listAttributeName is a required configuration property for this plugin.");
        }
        EmsBean bean = ((MBeanResourceComponent)context.getParentResourceComponent()).getEmsBean();
        String objectName = config.getSimpleValue("objectName", null);
        if (objectName != null) {
            objectName = TemplateResolver.resolve(objectName, context.getParentResourceContext().getPluginConfiguration());
            bean = ((MBeanResourceComponent)context.getParentResourceComponent()).getEmsConnection().getBean(objectName);
        }
        if (bean == null) {
            throw new Exception("JMX bean not found.");
        }
        if (trace) {
            log.trace((Object)("Using JMX bean " + bean.getBeanName() + " for this discovery component"));
        }
        if ((attribute = this.getAttribute(bean, listAttributeName)) == null) {
            throw new Exception("Unknown attribute '" + listAttributeName + "' for JMX bean " + bean.getBeanName());
        }
        if (trace) {
            log.trace((Object)("Looking up list of values for attribute " + attribute.getName()));
        }
        if ((object = attribute.getValue()) instanceof String[]) {
            String[] values = (String[])object;
            if (trace) {
                log.trace((Object)("Found " + values.length + " values for attribute " + attribute.getName()));
            }
            HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>(values.length);
            for (String value : values) {
                if (trace) {
                    log.trace((Object)("Creating resource detail for attribute value " + value));
                }
                details.add(this.createResourceDetails(context, value));
            }
            return details;
        }
        throw new Exception("Attribute '" + listAttributeName + "' for JMX bean " + bean.getBeanName() + " must return a string array (String[])");
    }

    private EmsAttribute getAttribute(EmsBean bean, String attributeName) {
        List attributes = bean.refreshAttributes(Collections.singletonList(attributeName));
        for (EmsAttribute attribute : attributes) {
            if (!attributeName.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    protected abstract DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext<MBeanResourceComponent<?>> var1, String var2);
}

