/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.rhq.plugins.jmx;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gatein.rhq.plugins.jmx.TemplateResolver;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public abstract class MBeanAttributeResourceComponent
implements MeasurementFacet,
JMXComponent<MBeanResourceComponent<?>> {
    private static final Log log = LogFactory.getLog((String)"org.gatein.rhq.plugins.jmx");
    private MBeanResourceComponent<?> parent;
    private EmsBean bean;
    private String attributeValue;

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        boolean trace = log.isTraceEnabled();
        for (MeasurementScheduleRequest metric : metrics) {
            if (metric.getDataType() == DataType.MEASUREMENT) {
                Object value;
                EmsOperation operation = this.getOperation(this.bean, metric.getName());
                if (operation == null) continue;
                if (trace) {
                    log.trace((Object)("Gathering metric data by invoking operation " + operation.getName() + " with parameter " + this.attributeValue + " on JMX bean " + this.bean.getBeanName()));
                }
                if ((value = operation.invoke(new Object[]{this.attributeValue})) instanceof Number) {
                    Double doubleValue = ((Number)value).doubleValue();
                    if (trace) {
                        log.trace((Object)("Found numeric value " + doubleValue + " for metric data for " + metric.getName()));
                    }
                    report.addData(new MeasurementDataNumeric(metric, doubleValue));
                    continue;
                }
                log.warn((Object)("Value returned for operation " + operation.getName() + " and JMX bean " + this.bean.getBeanName() + " was not a numeric value."));
                continue;
            }
            log.warn((Object)("Data type " + metric.getDataType() + " not supported."));
        }
    }

    public void start(ResourceContext<MBeanResourceComponent<?>> context) throws InvalidPluginConfigurationException, Exception {
        this.parent = (MBeanResourceComponent)context.getParentResourceComponent();
        this.bean = this.parent.getEmsBean();
        this.attributeValue = this.parseAttributeValue(context.getResourceKey());
        String objectName = context.getPluginConfiguration().getSimpleValue("objectName", null);
        if (objectName != null) {
            objectName = TemplateResolver.resolve(objectName, this.parent.getResourceContext().getPluginConfiguration());
            this.bean = this.getEmsConnection().getBean(objectName);
        }
    }

    public void stop() {
        this.parent = null;
        this.attributeValue = null;
        this.bean = null;
    }

    public AvailabilityType getAvailability() {
        return this.parent.getAvailability();
    }

    public EmsConnection getEmsConnection() {
        return this.parent.getEmsConnection();
    }

    protected abstract String parseAttributeValue(String var1);

    private EmsOperation getOperation(EmsBean bean, String operationName) {
        EmsOperation operation = bean.getOperation(operationName, new Class[]{String.class});
        if (operation != null) {
            return operation;
        }
        StringBuilder sb = new StringBuilder(operationName.substring(0, 1).toUpperCase()).insert(0, "get").append(operationName.substring(1, operationName.length()));
        String getOperationName = sb.toString();
        operation = bean.getOperation(getOperationName, new Class[]{String.class});
        if (operation != null) {
            return operation;
        }
        log.warn((Object)("Operation '" + operationName + " or '" + getOperationName + "' not found on JMX bean " + bean.getBeanName()));
        return null;
    }
}

