/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.rhq.plugins.jmx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.configuration.Configuration;

public class TemplateResolver {
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("%([^%]+)%");

    private TemplateResolver() {
    }

    public static String resolve(String objectName, Configuration configuration) {
        Matcher m = TEMPLATE_PATTERN.matcher(objectName);
        while (m.find()) {
            String propName = m.group(1);
            String replacementValue = configuration.getSimpleValue(propName, null);
            objectName = objectName.replaceAll("%" + propName + "%", replacementValue);
            m = TEMPLATE_PATTERN.matcher(objectName);
        }
        return objectName;
    }
}

