/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtil {
    private static final DateTimeFormatter rfc1123DateFormat = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter iso8601DateFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);

    private DateUtil() {
    }

    public static Date parseRfc1123Date(String dateStr) {
        try {
            return rfc1123DateFormat.parseDateTime(dateStr).toDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parseIso8601DateTime(String dateStr) {
        try {
            return new DateTime((Object)dateStr).toDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatIso8601Date(Date date) {
        return DateUtil.formatIso8601Date(date.getTime());
    }

    public static String formatIso8601Date(long time) {
        return iso8601DateFormat.print(time);
    }

    public static String formatRfc1123Date(Date date) {
        return DateUtil.formatRfc1123Date(date.getTime());
    }

    public static String formatRfc1123Date(long timeStamp) {
        return rfc1123DateFormat.print(timeStamp);
    }
}

