/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public final class ResourceLoader {
    private ResourceLoader() {
    }

    public static InputStream open(String path) throws IOException {
        if (path.startsWith("res://")) {
            return ResourceLoader.openResource(path.substring(6));
        }
        File file = new File(path);
        return new FileInputStream(file);
    }

    public static InputStream openResource(String resource) throws IOException {
        ClassLoader cl = ResourceLoader.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(resource.trim());
        if (is == null) {
            throw new FileNotFoundException("Can not locate resource: " + resource);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String resource) throws IOException {
        InputStream is = ResourceLoader.openResource(resource);
        try {
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

