/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.shindig.common.util.ImmediateFuture;
import org.junit.Assert;
import org.junit.Test;

public class ImmediateFutureTest
extends Assert {
    @Test
    public void testGet() throws Exception {
        ImmediateFutureTest.assertEquals((Object)"foo", ImmediateFuture.newInstance((Object)"foo").get());
    }

    @Test
    public void testGetNull() throws Exception {
        ImmediateFutureTest.assertNull(ImmediateFuture.newInstance(null).get());
    }

    @Test
    public void testGetWithTimeout() throws Exception {
        ImmediateFutureTest.assertEquals((Object)"foo", ImmediateFuture.newInstance((Object)"foo").get(1L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testCancel() {
        Future stringFuture = ImmediateFuture.newInstance((Object)"foo");
        ImmediateFutureTest.assertFalse((boolean)stringFuture.cancel(true));
        ImmediateFutureTest.assertFalse((boolean)stringFuture.cancel(false));
        ImmediateFutureTest.assertFalse((boolean)stringFuture.isCancelled());
    }

    @Test
    public void testIsDone() {
        ImmediateFutureTest.assertTrue((boolean)ImmediateFuture.newInstance((Object)"foo").isDone());
    }

    @Test
    public void testErrorInstance() throws Exception {
        RuntimeException re = new RuntimeException();
        Future errorFuture = ImmediateFuture.errorInstance((Throwable)re);
        try {
            errorFuture.get();
            ImmediateFutureTest.fail();
        }
        catch (ExecutionException ee) {
            ImmediateFutureTest.assertSame((Object)re, (Object)ee.getCause());
        }
    }
}

