/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.extras.as.sample;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.extras.as.opensocial.model.ActivityEntry;
import org.apache.shindig.extras.as.opensocial.model.ActivityObject;
import org.apache.shindig.extras.as.opensocial.spi.ActivityStreamService;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStreamsJsonDbService
implements ActivityStreamService {
    JsonDbOpensocialService jsonDb;
    JSONObject db;
    BeanConverter converter;
    private static final String ACTIVITYSTREAMS_TABLE = "activityEntries";

    @Inject
    public ActivityStreamsJsonDbService(JsonDbOpensocialService jsonDb, @Named(value="shindig.bean.converter.json") BeanConverter converter) {
        this.jsonDb = jsonDb;
        this.db = jsonDb.getDb();
        this.converter = converter;
    }

    @Override
    public Future<Void> createActivityEntry(UserId userId, GroupId groupId, String appId, Set<String> fields, ActivityEntry activityEntry, SecurityToken token) throws ProtocolException {
        try {
            JSONArray jsonArray;
            JSONObject jsonEntry = this.convertFromActivityEntry(activityEntry, fields);
            JSONObject jsonEntryObject = jsonEntry.getJSONObject(ActivityEntry.Field.OBJECT.toString());
            if (!jsonEntryObject.has(ActivityObject.Field.ID.toString())) {
                jsonEntryObject.put(ActivityObject.Field.ID.toString(), System.currentTimeMillis());
                jsonEntry.put(ActivityEntry.Field.OBJECT.toString(), (Object)jsonEntryObject);
            }
            if (this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(userId.getUserId(token))) {
                jsonArray = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(userId.getUserId(token));
            } else {
                jsonArray = new JSONArray();
                this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).put(userId.getUserId(token), (Object)jsonArray);
            }
            jsonArray.put((Object)jsonEntry);
            return ImmediateFuture.newInstance(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deleteActivityEntries(UserId userId, GroupId groupId, String appId, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        try {
            JSONArray activityEntries;
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(user) && (activityEntries = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(user)) != null) {
                JSONArray newList = new JSONArray();
                for (int i = 0; i < activityEntries.length(); ++i) {
                    JSONObject activityEntry = activityEntries.getJSONObject(i);
                    if (activityIds.contains(activityEntry.getJSONObject(ActivityEntry.Field.OBJECT.toString()).getString(ActivityObject.Field.ID.toString()))) continue;
                    newList.put((Object)activityEntry);
                }
                this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).put(user, (Object)newList);
            }
            return ImmediateFuture.newInstance(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<ActivityEntry> getActivityEntry(UserId userId, GroupId groupId, String appId, Set<String> fields, String activityId, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(user)) {
                JSONArray activityEntries = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(user);
                for (int i = 0; i < activityEntries.length(); ++i) {
                    JSONObject activityEntry = activityEntries.getJSONObject(i);
                    JSONObject actor = activityEntry.getJSONObject(ActivityEntry.Field.ACTOR.toString());
                    String actorId = actor.get(ActivityObject.Field.ID.toString()).toString();
                    if (!actorId.equals(user) || !activityEntry.getJSONObject(ActivityEntry.Field.OBJECT.toString()).get(ActivityObject.Field.ID.toString()).toString().equals(activityId)) continue;
                    return ImmediateFuture.newInstance((Object)this.jsonDb.filterFields(activityEntry, fields, ActivityEntry.class));
                }
            }
            throw new ProtocolException(400, "ActivityEntry not found");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<ActivityEntry>> getActivityEntries(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        ArrayList result = Lists.newArrayList();
        try {
            Set idSet = this.jsonDb.getIdSet(userIds, groupId, token);
            for (String id : idSet) {
                if (!this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(id)) continue;
                JSONArray activityEntries = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(id);
                for (int i = 0; i < activityEntries.length(); ++i) {
                    JSONObject activityEntry = activityEntries.getJSONObject(i);
                    result.add(this.jsonDb.filterFields(activityEntry, fields, ActivityEntry.class));
                }
            }
            return ImmediateFuture.newInstance((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<ActivityEntry>> getActivityEntries(UserId userId, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        ArrayList result = Lists.newArrayList();
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(user)) {
                JSONArray activityEntries = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(user);
                for (int i = 0; i < activityEntries.length(); ++i) {
                    JSONObject activityEntry = activityEntries.getJSONObject(i);
                    JSONObject actor = new JSONObject(activityEntry.get(ActivityEntry.Field.ACTOR.toString()));
                    String actorId = actor.get(ActivityObject.Field.ID.toString()).toString();
                    if (!actorId.equals(user) || !activityIds.contains(activityEntry.getJSONObject(ActivityEntry.Field.OBJECT.toString()).getString(ActivityObject.Field.ID.toString()).toString())) continue;
                    result.add(this.jsonDb.filterFields(activityEntry, fields, ActivityEntry.class));
                }
            }
            return ImmediateFuture.newInstance((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    private JSONObject convertFromActivityEntry(ActivityEntry activityEntry, Set<String> fields) throws JSONException {
        return new JSONObject(this.converter.convertToString((Object)activityEntry));
    }
}

