/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.extras.as.opensocial.service;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.extras.as.opensocial.model.ActivityEntry;
import org.apache.shindig.extras.as.opensocial.spi.ActivityStreamService;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.UserId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="activitystreams", path="/{userId}+/{groupId}/{appId}/{activityEntryId}+")
public class ActivityStreamsHandler {
    private final ActivityStreamService service;
    private final ContainerConfig config;

    @Inject
    public ActivityStreamsHandler(ActivityStreamService service, ContainerConfig config) {
        this.service = service;
        this.config = config;
    }

    @Operation(httpMethods={"DELETE"})
    public Future<?> delete(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        ImmutableSet activityEntryIds = ImmutableSet.copyOf((Collection)request.getListParameter("activityEntryId"));
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular((Collection)userIds, (String)"Multiple userIds not supported");
        return this.service.deleteActivityEntries((UserId)Iterables.getOnlyElement((Iterable)userIds), request.getGroup(), request.getAppId(), (Set<String>)activityEntryIds, request.getToken());
    }

    @Operation(httpMethods={"PUT"}, bodyParam="activityEntry")
    public Future<?> update(SocialRequestItem request) throws ProtocolException {
        return this.create(request);
    }

    @Operation(httpMethods={"POST"}, bodyParam="activityEntry")
    public Future<?> create(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        List activityEntryIds = request.getListParameter("activityEntryId");
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular((Collection)userIds, (String)"Multiple userIds not supported");
        HandlerPreconditions.requireEmpty((Collection)activityEntryIds, (String)"Cannot specify activityEntryId in create");
        return this.service.createActivityEntry((UserId)Iterables.getOnlyElement((Iterable)userIds), request.getGroup(), request.getAppId(), request.getFields(), (ActivityEntry)request.getTypedParameter("activityEntry", ActivityEntry.class), request.getToken());
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        Set userIds = request.getUsers();
        ImmutableSet optionalActivityIds = ImmutableSet.copyOf((Collection)request.getListParameter("activityEntryId"));
        CollectionOptions options = new CollectionOptions((RequestItem)request);
        HandlerPreconditions.requireNotEmpty((Collection)userIds, (String)"No userId specified");
        if (userIds.size() > 1 && !optionalActivityIds.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch same activityEntryIds for multiple userIds");
        }
        if (!optionalActivityIds.isEmpty()) {
            if (optionalActivityIds.size() == 1) {
                return this.service.getActivityEntry((UserId)userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), (String)optionalActivityIds.iterator().next(), request.getToken());
            }
            return this.service.getActivityEntries((UserId)userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), options, (Set<String>)optionalActivityIds, request.getToken());
        }
        return this.service.getActivityEntries(userIds, request.getGroup(), request.getAppId(), request.getFields(), options, request.getToken());
    }

    @Operation(httpMethods={"GET"}, path="/@supportedFields")
    public List<Object> supportedFields(RequestItem request) {
        String container = (String)Objects.firstNonNull((Object)request.getToken().getContainer(), (Object)"default");
        return this.config.getList(container, "${Cur['gadgets.features'].opensocial.supportedFields.activitystream}");
    }
}

