/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.easymock.EasyMock;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetTest
extends EasyMockTestCase {
    private static final String SPEC_URL = "http://example.org/gadget.xml";
    private static final String SPEC_XML = "<Module><ModulePrefs title='title'>  <Preload href='http://example.org/foo'/>  <Locale>    <msg name='name'>VALUE</msg>  </Locale></ModulePrefs><Content type='html'>DEFAULT VIEW</Content><Content view='one' type='html'>VIEW ONE</Content><Content view='two' type='html'>VIEW TWO</Content></Module>";
    private final DummyContext context = new DummyContext();

    @Test
    public void getLocale() throws Exception {
        Gadget gadget = new Gadget().setContext((GadgetContext)this.context).setSpec(new GadgetSpec(Uri.parse((String)SPEC_URL), SPEC_XML));
        LocaleSpec localeSpec = gadget.getLocale();
        GadgetTest.assertEquals((String)"VALUE", (String)((String)localeSpec.getMessageBundle().getMessages().get("name")));
    }

    private GadgetFeature makeFeature(String name, List<String> deps) throws GadgetException {
        JsLibrary lib = JsLibrary.create((JsLibrary.Type)JsLibrary.Type.INLINE, (String)name, (String)name, null);
        if (deps == null) {
            deps = Lists.newArrayList();
        }
        return new GadgetFeature(name, Arrays.asList(lib), (Collection)deps);
    }

    @Test
    public void testGetFeatures() throws Exception {
        String xml = "<Module><ModulePrefs title=\"hello\"><Require feature=\"required1\"/><Require feature=\"required2\"/></ModulePrefs><Content type=\"html\"/></Module>";
        ArrayList features = Lists.newArrayList((Object[])new GadgetFeature[]{this.makeFeature("required1", Lists.newArrayList((Object[])new String[]{"required2", "required3"})), this.makeFeature("required2", Lists.newArrayList((Object[])new String[]{"required3", "required4", "required5"})), this.makeFeature("required3", Lists.newArrayList((Object[])new String[]{"required4", "required5"})), this.makeFeature("required4", null), this.makeFeature("required4", null)});
        GadgetFeatureRegistry registry = (GadgetFeatureRegistry)this.mock(GadgetFeatureRegistry.class);
        Gadget gadget = new Gadget().setContext((GadgetContext)this.context).setGadgetFeatureRegistry(registry).setSpec(new GadgetSpec(Uri.parse((String)SPEC_URL), xml));
        HashSet needed = Sets.newHashSet((Object[])new String[]{"required1", "required2"});
        EasyMock.expect((Object)registry.getFeatures((Collection)needed)).andReturn((Object)features).anyTimes();
        this.replay(registry);
        List requiredFeatures = gadget.getAllFeatures();
        GadgetTest.assertEquals((int)5, (int)requiredFeatures.size());
        GadgetTest.assertTrue((((String)requiredFeatures.get(0)).equals("required4") || ((String)requiredFeatures.get(0)).equals("required5") ? 1 : 0) != 0);
        GadgetTest.assertTrue((((String)requiredFeatures.get(1)).equals("required4") || ((String)requiredFeatures.get(0)).equals("required5") ? 1 : 0) != 0);
        GadgetTest.assertEquals((String)"required3", (String)((String)requiredFeatures.get(2)));
        GadgetTest.assertEquals((String)"required2", (String)((String)requiredFeatures.get(3)));
        GadgetTest.assertEquals((String)"required1", (String)((String)requiredFeatures.get(4)));
        GadgetTest.assertTrue((requiredFeatures == gadget.getAllFeatures() ? 1 : 0) != 0);
    }

    private static class DummyContext
    extends GadgetContext {
        public String view = super.getView();
        public String container = super.getContainer();

        protected DummyContext() {
        }

        public String getView() {
            return this.view;
        }

        public String getContainer() {
            return this.container;
        }
    }
}

