/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.easymock.EasyMock;

public class JsLibraryTest
extends EasyMockTestCase {
    private static final String INLINE_JS = "var hello = 'world'; alert(hello);";
    private static final String FILE_JS = "gadgets.test.pattern = function(){};";
    private static final String UNCOMPRESSED_FILE_JS = "/** Some comments*/\ngadgets.test.pattern = function() {};";
    private static final String URL_JS = "while(true){alert('hello');}";

    public void testInline() throws GadgetException {
        JsLibrary lib = JsLibrary.create((JsLibrary.Type)JsLibrary.Type.INLINE, (String)INLINE_JS, null, null);
        JsLibraryTest.assertEquals((Object)JsLibrary.Type.INLINE, (Object)lib.getType());
        JsLibraryTest.assertEquals((String)INLINE_JS, (String)lib.getContent());
    }

    public void testFile() throws Exception {
        File temp = File.createTempFile(this.getName(), ".js-standalone");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(FILE_JS);
        out.close();
        JsLibrary lib = JsLibrary.create((JsLibrary.Type)JsLibrary.Type.FILE, (String)temp.getPath(), null, null);
        JsLibraryTest.assertEquals((Object)JsLibrary.Type.FILE, (Object)lib.getType());
        JsLibraryTest.assertEquals((String)FILE_JS, (String)lib.getContent());
    }

    public void testOptimized() throws Exception {
        File uncompressed = File.createTempFile(this.getName(), ".js");
        uncompressed.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(uncompressed));
        out.write(UNCOMPRESSED_FILE_JS);
        out.close();
        JsLibrary lib = JsLibrary.create((JsLibrary.Type)JsLibrary.Type.FILE, (String)uncompressed.getPath(), null, null);
        JsLibraryTest.assertEquals((Object)JsLibrary.Type.FILE, (Object)lib.getType());
        JsLibraryTest.assertEquals((String)UNCOMPRESSED_FILE_JS, (String)lib.getContent());
        JsLibraryTest.assertEquals((String)UNCOMPRESSED_FILE_JS, (String)lib.getDebugContent());
        File compressed = new File(uncompressed.getPath().replace(".js", ".opt.js"));
        compressed.createNewFile();
        compressed.deleteOnExit();
        out = new BufferedWriter(new FileWriter(compressed));
        out.write(FILE_JS);
        out.close();
        lib = JsLibrary.create((JsLibrary.Type)JsLibrary.Type.FILE, (String)uncompressed.getPath(), null, null);
        JsLibraryTest.assertEquals((Object)JsLibrary.Type.FILE, (Object)lib.getType());
        JsLibraryTest.assertEquals((String)FILE_JS, (String)lib.getContent());
        JsLibraryTest.assertEquals((String)UNCOMPRESSED_FILE_JS, (String)lib.getDebugContent());
    }

    public void testUrl() throws Exception {
        HttpFetcher mockFetcher = (HttpFetcher)this.mock(HttpFetcher.class);
        Uri location = Uri.parse((String)"http://example.org/file.js");
        HttpRequest request = new HttpRequest(location);
        HttpResponse response = new HttpResponseBuilder().setResponse(URL_JS.getBytes()).create();
        EasyMock.expect((Object)mockFetcher.fetch((HttpRequest)EasyMock.eq((Object)request))).andReturn((Object)response);
        this.replay();
        JsLibrary lib = JsLibrary.create((JsLibrary.Type)JsLibrary.Type.URL, (String)location.toString(), null, (HttpFetcher)mockFetcher);
        this.verify();
        JsLibraryTest.assertEquals((String)URL_JS, (String)lib.getContent());
        JsLibraryTest.assertEquals((String)URL_JS, (String)lib.getDebugContent());
    }
}

