/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.spec.Preload;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.junit.Assert;
import org.junit.Test;

public class OAuthArgumentsTest {
    @Test
    public void testInitFromPreload() throws Exception {
        String xml = "<Preload href='http://www.example.com' oauth_service_name='service' OAUTH_TOKEN_NAME='token' OAUTH_REQuest_token='requesttoken' oauth_request_token_secret='tokensecret' OAUTH_USE_TOKEN='never' random='stuff'/>";
        Preload preload = new Preload(XmlUtil.parse((String)xml), Uri.parse((String)""));
        OAuthArguments params = new OAuthArguments((RequestAuthenticationInfo)preload);
        Assert.assertEquals((Object)"service", (Object)params.getServiceName());
        Assert.assertEquals((Object)"token", (Object)params.getTokenName());
        Assert.assertEquals((Object)"requesttoken", (Object)params.getRequestToken());
        Assert.assertEquals((Object)"tokensecret", (Object)params.getRequestTokenSecret());
        Assert.assertEquals((Object)OAuthArguments.UseToken.NEVER, (Object)params.getUseToken());
        Assert.assertNull((Object)params.getOrigClientState());
        Assert.assertFalse((boolean)params.getBypassSpecCache());
        Assert.assertEquals((Object)"stuff", (Object)params.getRequestOption("random"));
    }

    private FakeHttpServletRequest makeDummyRequest() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        req.setParameter("OAUTH_USE_TOKEN", true, new String[]{"never"});
        req.setParameter("OAUTH_SERVICE_NAME", true, new String[]{"service"});
        req.setParameter("OAUTH_TOKEN_NAME", true, new String[]{"token"});
        req.setParameter("OAUTH_REQUEST_TOKEN", true, new String[]{"reqtoken"});
        req.setParameter("OAUTH_REQUEST_TOKEN_SECRET", true, new String[]{"secret"});
        req.setParameter("oauthState", true, new String[]{"state"});
        req.setParameter("bypassSpecCache", true, new String[]{"1"});
        req.setParameter("signOwner", true, new String[]{"false"});
        req.setParameter("signViewer", true, new String[]{"false"});
        req.setParameter("random", true, new String[]{"stuff"});
        return req;
    }

    @Test
    public void testInitFromRequest() throws Exception {
        FakeHttpServletRequest req = this.makeDummyRequest();
        OAuthArguments args = new OAuthArguments(AuthType.SIGNED, (HttpServletRequest)req);
        Assert.assertEquals((Object)OAuthArguments.UseToken.NEVER, (Object)args.getUseToken());
        Assert.assertEquals((Object)"service", (Object)args.getServiceName());
        Assert.assertEquals((Object)"token", (Object)args.getTokenName());
        Assert.assertEquals((Object)"reqtoken", (Object)args.getRequestToken());
        Assert.assertEquals((Object)"secret", (Object)args.getRequestTokenSecret());
        Assert.assertEquals((Object)"state", (Object)args.getOrigClientState());
        Assert.assertTrue((boolean)args.getBypassSpecCache());
        Assert.assertFalse((boolean)args.getSignOwner());
        Assert.assertFalse((boolean)args.getSignViewer());
        Assert.assertEquals((Object)"stuff", (Object)args.getRequestOption("random"));
        Assert.assertEquals((Object)"stuff", (Object)args.getRequestOption("rAnDoM"));
    }

    @Test
    public void testInitFromRequest_defaults() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        OAuthArguments args = new OAuthArguments(AuthType.SIGNED, (HttpServletRequest)req);
        Assert.assertEquals((Object)OAuthArguments.UseToken.NEVER, (Object)args.getUseToken());
        Assert.assertEquals((Object)"", (Object)args.getServiceName());
        Assert.assertEquals((Object)"", (Object)args.getTokenName());
        Assert.assertNull((Object)args.getRequestToken());
        Assert.assertNull((Object)args.getRequestTokenSecret());
        Assert.assertNull((Object)args.getOrigClientState());
        Assert.assertFalse((boolean)args.getBypassSpecCache());
        Assert.assertTrue((boolean)args.getSignOwner());
        Assert.assertTrue((boolean)args.getSignViewer());
        Assert.assertNull((Object)args.getRequestOption("random"));
    }

    @Test
    public void testInitFromRequest_oauthDefaults() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        OAuthArguments args = new OAuthArguments(AuthType.OAUTH, (HttpServletRequest)req);
        Assert.assertEquals((Object)OAuthArguments.UseToken.ALWAYS, (Object)args.getUseToken());
    }

    @Test
    public void testNoArgConstructorDefaults() throws Exception {
        OAuthArguments args = new OAuthArguments();
        Assert.assertEquals((Object)OAuthArguments.UseToken.ALWAYS, (Object)args.getUseToken());
        Assert.assertEquals((Object)"", (Object)args.getServiceName());
        Assert.assertEquals((Object)"", (Object)args.getTokenName());
        Assert.assertNull((Object)args.getRequestToken());
        Assert.assertNull((Object)args.getRequestTokenSecret());
        Assert.assertNull((Object)args.getOrigClientState());
        Assert.assertFalse((boolean)args.getBypassSpecCache());
        Assert.assertFalse((boolean)args.getSignOwner());
        Assert.assertFalse((boolean)args.getSignViewer());
    }

    @Test
    public void testGetAndSet() throws Exception {
        OAuthArguments args = new OAuthArguments();
        args.setBypassSpecCache(true);
        Assert.assertTrue((boolean)args.getBypassSpecCache());
        args.setOrigClientState("thestate");
        Assert.assertEquals((Object)"thestate", (Object)args.getOrigClientState());
        args.setRequestToken("rt");
        Assert.assertEquals((Object)"rt", (Object)args.getRequestToken());
        args.setRequestTokenSecret("rts");
        Assert.assertEquals((Object)"rts", (Object)args.getRequestTokenSecret());
        args.setServiceName("s");
        Assert.assertEquals((Object)"s", (Object)args.getServiceName());
        args.setSignOwner(true);
        Assert.assertTrue((boolean)args.getSignOwner());
        args.setSignViewer(true);
        Assert.assertTrue((boolean)args.getSignViewer());
        args.setUseToken(OAuthArguments.UseToken.IF_AVAILABLE);
        Assert.assertEquals((Object)OAuthArguments.UseToken.IF_AVAILABLE, (Object)args.getUseToken());
        args.setRequestOption("foo", "bar");
        Assert.assertEquals((Object)"bar", (Object)args.getRequestOption("foo"));
        args.removeRequestOption("foo");
        Assert.assertNull((Object)args.getRequestOption("foo"));
    }

    @Test
    public void testCopyConstructor() throws Exception {
        FakeHttpServletRequest req = this.makeDummyRequest();
        OAuthArguments args = new OAuthArguments(AuthType.OAUTH, (HttpServletRequest)req);
        args = new OAuthArguments(args);
        Assert.assertEquals((Object)OAuthArguments.UseToken.NEVER, (Object)args.getUseToken());
        Assert.assertEquals((Object)"service", (Object)args.getServiceName());
        Assert.assertEquals((Object)"token", (Object)args.getTokenName());
        Assert.assertEquals((Object)"reqtoken", (Object)args.getRequestToken());
        Assert.assertEquals((Object)"secret", (Object)args.getRequestTokenSecret());
        Assert.assertEquals((Object)"state", (Object)args.getOrigClientState());
        Assert.assertTrue((boolean)args.getBypassSpecCache());
        Assert.assertFalse((boolean)args.getSignOwner());
        Assert.assertFalse((boolean)args.getSignViewer());
    }

    @Test
    public void testCopyConstructor_options() throws Exception {
        FakeHttpServletRequest req = this.makeDummyRequest();
        OAuthArguments args = new OAuthArguments(AuthType.OAUTH, (HttpServletRequest)req);
        args = new OAuthArguments(args);
        args.setRequestOption("foo", "bar");
        args.setRequestOption("quux", "baz");
        Assert.assertEquals((Object)"bar", (Object)args.getRequestOption("foo"));
        Assert.assertEquals((Object)"baz", (Object)args.getRequestOption("quux"));
    }

    @Test
    public void testParseUseToken() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        req.setParameter("OAUTH_USE_TOKEN", new String[]{"ALWAYS"});
        OAuthArguments args = new OAuthArguments(AuthType.SIGNED, (HttpServletRequest)req);
        Assert.assertEquals((Object)OAuthArguments.UseToken.ALWAYS, (Object)args.getUseToken());
        req.setParameter("OAUTH_USE_TOKEN", new String[]{"if_available"});
        args = new OAuthArguments(AuthType.SIGNED, (HttpServletRequest)req);
        Assert.assertEquals((Object)OAuthArguments.UseToken.IF_AVAILABLE, (Object)args.getUseToken());
        req.setParameter("OAUTH_USE_TOKEN", new String[]{"never"});
        args = new OAuthArguments(AuthType.SIGNED, (HttpServletRequest)req);
        Assert.assertEquals((Object)OAuthArguments.UseToken.NEVER, (Object)args.getUseToken());
        req.setParameter("OAUTH_USE_TOKEN", new String[]{""});
        args = new OAuthArguments(AuthType.SIGNED, (HttpServletRequest)req);
        Assert.assertEquals((Object)OAuthArguments.UseToken.NEVER, (Object)args.getUseToken());
        req.setParameter("OAUTH_USE_TOKEN", new String[]{""});
        args = new OAuthArguments(AuthType.OAUTH, (HttpServletRequest)req);
        Assert.assertEquals((Object)OAuthArguments.UseToken.ALWAYS, (Object)args.getUseToken());
        try {
            req.setParameter("OAUTH_USE_TOKEN", new String[]{"stuff"});
            new OAuthArguments(AuthType.OAUTH, (HttpServletRequest)req);
            Assert.fail((String)"Should have thrown");
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }
}

